/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.ReattachVisitor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.CollectionType;

public class OnUpdateVisitor
extends ReattachVisitor {
    OnUpdateVisitor(EventSource session, Serializable key) {
        super(session, key);
    }

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection == CollectionType.UNFETCHED_COLLECTION) {
            return null;
        }
        EventSource session = this.getSession();
        Serializable key = this.getKey();
        CollectionPersister persister = session.getFactory().getCollectionPersister(type.getRole());
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection wrapper = (PersistentCollection)collection;
            if (wrapper.setCurrentSession(session)) {
                if (!OnUpdateVisitor.isOwnerUnchanged(wrapper, persister, key)) {
                    this.removeCollection(persister, key, session);
                }
                this.reattachCollection(wrapper, type);
            } else {
                this.removeCollection(persister, key, session);
            }
        } else {
            this.removeCollection(persister, key, session);
        }
        return null;
    }
}

