/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.taglib;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import net.sf.navigator.displayer.MenuDisplayer;
import net.sf.navigator.menu.MenuComponent;
import net.sf.navigator.menu.MenuRepository;
import net.sf.navigator.taglib.UseMenuDisplayerTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.RequestUtils;

public class DisplayMenuTag
extends TagSupport {
    protected final transient Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String name;
    private String target;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting name to: " + name));
        }
        this.name = name;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public int doStartTag() throws JspException {
        MenuDisplayer displayer = (MenuDisplayer)this.pageContext.getAttribute("net.sf.navigator.taglib.DISPLAYER");
        if (displayer == null) {
            throw new JspException("Could not retrieve the menu displayer.");
        }
        MenuRepository repository = (MenuRepository)this.pageContext.getAttribute("net.sf.navigator.repositoryKey");
        if (repository == null) {
            throw new JspException("Could not obtain the menu repository");
        }
        MenuComponent menu = repository.getMenu(this.name);
        if (menu != null) {
            try {
                if (this.target != null) {
                    displayer.setTarget(this.target);
                }
                try {
                    this.setPageLocation(menu);
                }
                catch (MalformedURLException m) {
                    this.log.error((Object)("Incorrect action or forward: " + m.getMessage()));
                    this.log.warn((Object)("Menu '" + menu.getName() + "' location set to #"));
                    menu.setLocation("#");
                }
                displayer.display(menu);
                displayer.setTarget(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JspException((Throwable)e);
            }
        }
        String error = UseMenuDisplayerTag.messages.getString("menu.not.found") + " " + this.name;
        this.log.warn((Object)error);
        try {
            this.pageContext.getOut().write(error);
        }
        catch (IOException io) {
            throw new JspException(error);
        }
        return 0;
    }

    protected void setPageLocation(MenuComponent menu) throws MalformedURLException, JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        this.setLocation(menu);
        String url = menu.getLocation();
        if (url != null && url.indexOf("${") > -1) {
            String queryString = null;
            if (url.indexOf("?") > -1) {
                queryString = url.substring(url.indexOf("?") + 1);
                url = url.substring(0, url.indexOf(queryString));
            }
            StringBuffer sb = new StringBuffer();
            if (queryString != null) {
                sb = this.parseString(queryString, request);
                menu.setUrl(url + sb.toString());
            } else {
                sb = this.parseString(url, request);
                menu.setUrl(sb.toString());
            }
        } else {
            menu.setUrl(url);
        }
        MenuComponent[] subMenus = menu.getMenuComponents();
        if (subMenus.length > 0) {
            for (int i = 0; i < subMenus.length; ++i) {
                this.setPageLocation(subMenus[i]);
            }
        }
    }

    protected void setLocation(MenuComponent menu) throws MalformedURLException {
        block9: {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            if (menu.getLocation() == null) {
                try {
                    if (menu.getPage() != null) {
                        menu.setLocation(request.getContextPath() + this.getPage(menu.getPage()));
                    } else if (menu.getForward() != null) {
                        String fwd = RequestUtils.computeURL((PageContext)this.pageContext, (String)menu.getForward(), null, null, null, null, null, (boolean)false);
                        menu.setLocation(fwd);
                    } else if (menu.getAction() != null) {
                        String action = RequestUtils.computeURL((PageContext)this.pageContext, null, null, null, (String)menu.getAction(), null, null, (boolean)false);
                        menu.setLocation(action);
                    }
                }
                catch (NoClassDefFoundError e) {
                    if (menu.getForward() != null) {
                        throw new MalformedURLException("forward '" + menu.getForward() + "' invalid - no struts.jar");
                    }
                    if (menu.getAction() == null) break block9;
                    throw new MalformedURLException("action '" + menu.getAction() + "' invalid - no struts.jar");
                }
            }
        }
    }

    protected String getPage(String page) {
        if (page.startsWith("/")) {
            return page;
        }
        page = "/" + page;
        return page;
    }

    private StringBuffer parseString(String str, HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        while (str.indexOf("${") >= 0) {
            sb.append(str.substring(0, str.indexOf("${")));
            String variable = str.substring(str.indexOf("${") + 2, str.indexOf("}"));
            String value = (String)this.pageContext.findAttribute(variable);
            if (value == null) {
                value = request.getParameter(variable);
            }
            if (value == null) {
                this.log.warn((Object)("Value for '" + variable + "' not found in pageContext or as a request parameter"));
            }
            sb.append(value);
            str = str.substring(str.indexOf("}") + 1, str.length());
        }
        return sb.append(str);
    }

    public void release() {
        this.name = null;
        this.target = null;
    }
}

