package tudu.web;

import java.util.Map;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;

import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.mvc.SimpleFormController;

import tudu.domain.model.TodoList;
import tudu.service.TodoListsManager;

public class EditTodoListController extends SimpleFormController {

	private TodoListsManager todoListsManager;
	
	public void onSubmitAction(ActionRequest request, ActionResponse response,
            Object command,	BindException errors) throws Exception {
		System.out.println("$$$$$$$$$$$$$$ onSubmitAction");
		TodoList todoList = (TodoList)command;
		todoListsManager.updateTodoList(todoList);
		//response.setRenderParameter("action",getFormView());
	}

	protected void initBinder(PortletRequest request, PortletRequestDataBinder binder)
																		throws Exception {
		System.out.println("$$$$$$$$$$$$$$ initBinder");
	}
		
	protected Object formBackingObject(PortletRequest request) throws Exception {
		System.out.println("$$$$$$$$$$$$$$ formBackingObject");
		System.out.println("                 -> name = "+request.getParameter("name"));
		String listId = request.getParameter("listId");
		return todoListsManager.findTodoList(listId);
	}

	protected Map referenceData(PortletRequest request, Object cms, Errors errors) throws Exception {
		System.out.println("$$$$$$$$$$$$$$ referenceData");
		return null;
	}

	public TodoListsManager getTodoListsManager() {
		return todoListsManager;
	}

	public void setTodoListsManager(TodoListsManager todoListsManager) {
		this.todoListsManager = todoListsManager;
	}

}
