package tudu.web;

import java.util.Collection;

import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractController;

import tudu.domain.model.TodoList;
import tudu.domain.model.User;
import tudu.service.TodoListsManager;
import tudu.service.UserManager;

public class ShowTodoListsController extends AbstractController {

	private UserManager userManager;
	private TodoListsManager todoListsManager;

    public ModelAndView handleRenderRequestInternal(RenderRequest request,
            RenderResponse response) throws Exception {
		User user = userManager.findUser("tttt");
        Collection<TodoList> todoLists = user.getTodoLists();
        return new ModelAndView("todolists","todolists",todoLists);
    }

	public TodoListsManager getTodoListsManager() {
		return todoListsManager;
	}

	public void setTodoListsManager(TodoListsManager todoListsManager) {
		this.todoListsManager = todoListsManager;
	}

	public UserManager getUserManager() {
		return userManager;
	}

	public void setUserManager(UserManager userManager) {
		this.userManager = userManager;
	}
}
