package tudu.web;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractController;

import tudu.domain.model.Todo;
import tudu.domain.model.TodoList;
import tudu.service.TodoListsManager;
import tudu.service.TodosManager;

public class ShowTodosController extends AbstractController {

	private TodoListsManager todoListsManager;
	private TodosManager todosManager;

    public ModelAndView handleRenderRequestInternal(RenderRequest request,
            RenderResponse response) throws Exception {
		String id=request.getParameter("listId");
		System.out.println("id = "+id);
		TodoList todoList=todoListsManager.findTodoList(id);
		Collection<Todo> todos=todoList.getTodos();
		System.out.println("todos size = "+todos.size());

		Map model=new HashMap();
		model.put("todolist",todoList);
		model.put("todos",todos);
		return new ModelAndView("todos",model);
    }

	public TodoListsManager getTodoListsManager() {
		return todoListsManager;
	}

	public void setTodoListsManager(TodoListsManager todoListsManager) {
		this.todoListsManager = todoListsManager;
	}

	public TodosManager getTodosManager() {
		return todosManager;
	}

	public void setTodosManager(TodosManager todosManager) {
		this.todosManager = todosManager;
	}
}
