/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter;

import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.Expression;
import org.activemq.filter.Filter;

public class ExpressionFilter
implements Filter {
    private Expression expression;

    public ExpressionFilter(Expression expression) {
        this.expression = expression;
    }

    public boolean matches(Message message) throws JMSException {
        Object value = this.expression.evaluate(message);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public boolean isWildcard() {
        return false;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String toString() {
        return "Filter: " + this.expression;
    }
}

