/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.impl;

import java.util.Map;
import javax.transaction.xa.XAException;
import org.activemq.message.ActiveMQXid;
import org.activemq.service.impl.AbstractTransaction;
import org.activemq.service.impl.TransactionManagerImpl;
import org.activemq.store.TransactionStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XATransactionCommand
extends AbstractTransaction {
    private static final Log log = LogFactory.getLog((Class)TransactionManagerImpl.class);
    private ActiveMQXid xid;
    private transient Map xaTxs;
    private transient TransactionStore transactionStore;

    public XATransactionCommand(ActiveMQXid xid, Map xaTxs, TransactionStore transactionStore) {
        this.xid = xid;
        this.xaTxs = xaTxs;
        this.transactionStore = transactionStore;
    }

    public void initialise(Map xaTxs, TransactionStore preparedTransactions) {
        this.xaTxs = xaTxs;
        this.transactionStore = preparedTransactions;
    }

    public void commit(boolean onePhase) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("XA Transaction commit: " + this.xid));
        }
        switch (this.getState()) {
            case 0: {
                this.checkForPreparedState(onePhase);
                this.setStateFinished();
                break;
            }
            case 1: {
                this.checkForPreparedState(onePhase);
                this.doPrePrepare();
                this.setStateFinished();
                this.transactionStore.commit(this.getTransactionId(), false);
                this.doPostCommit();
                break;
            }
            case 2: {
                this.setStateFinished();
                this.transactionStore.commit(this.getTransactionId(), true);
                this.doPostCommit();
                break;
            }
            default: {
                this.illegalStateTransition("commit");
            }
        }
    }

    private void illegalStateTransition(String callName) throws XAException {
        XAException xae = new XAException("Cannot call " + callName + " now.");
        xae.errorCode = -6;
        throw xae;
    }

    private void checkForPreparedState(boolean onePhase) throws XAException {
        if (!onePhase) {
            XAException xae = new XAException("Cannot do 2 phase commit if the transaction has not been prepared.");
            xae.errorCode = -6;
            throw xae;
        }
    }

    private void doPrePrepare() throws XAException {
        try {
            this.prePrepare();
        }
        catch (XAException e) {
            throw e;
        }
        catch (Throwable e) {
            log.warn((Object)"PRE-PREPARE FAILED: ", e);
            this.rollback();
            XAException xae = new XAException("PRE-PREPARE FAILED: Transaction rolled back.");
            xae.errorCode = 104;
            xae.initCause(e);
            throw xae;
        }
    }

    private void doPostCommit() throws XAException {
        try {
            this.postCommit();
        }
        catch (Throwable e) {
            log.warn((Object)"POST COMMIT FAILED: ", e);
            XAException xae = new XAException("POST COMMIT FAILED");
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
    }

    public void rollback() throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("XA Transaction rollback: " + this.xid));
        }
        switch (this.getState()) {
            case 0: {
                this.setStateFinished();
                break;
            }
            case 1: {
                this.setStateFinished();
                this.transactionStore.rollback(this.getTransactionId());
                this.doPostRollback();
                break;
            }
            case 2: {
                this.setStateFinished();
                this.transactionStore.rollback(this.getTransactionId());
                this.doPostRollback();
            }
        }
    }

    private void doPostRollback() throws XAException {
        try {
            this.postRollback();
        }
        catch (Throwable e) {
            log.warn((Object)"POST ROLLBACK FAILED: ", e);
            XAException xae = new XAException("POST ROLLBACK FAILED");
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
    }

    public int prepare() throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("XA Transaction prepare: " + this.xid));
        }
        switch (this.getState()) {
            case 0: {
                this.setStateFinished();
                return 3;
            }
            case 1: {
                this.doPrePrepare();
                this.setState((byte)2);
                this.transactionStore.prepare(this.getTransactionId());
                return 0;
            }
        }
        this.illegalStateTransition("prepare");
        return 3;
    }

    private void setStateFinished() {
        this.setState((byte)3);
        this.xaTxs.remove(this.xid);
    }

    public boolean isXaTransacted() {
        return true;
    }

    public Object getTransactionId() {
        return this.xid;
    }
}

