/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.cache;

import java.io.IOException;
import java.util.Map;
import javax.jms.JMSException;
import org.activemq.store.MessageStore;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.TransactionStore;
import org.activemq.store.cache.CacheMessageStore;
import org.activemq.store.cache.CacheTopicMessageStore;
import org.activemq.store.cache.MessageCache;
import org.activemq.store.cache.SimpleMessageCache;

public abstract class CachePersistenceAdapter
implements PersistenceAdapter {
    private PersistenceAdapter longTermPersistence;

    public CachePersistenceAdapter() {
    }

    public CachePersistenceAdapter(PersistenceAdapter longTermPersistence) throws IOException {
        this.longTermPersistence = longTermPersistence;
    }

    public Map getInitialDestinations() {
        return this.longTermPersistence.getInitialDestinations();
    }

    public MessageStore createQueueMessageStore(String destinationName) throws JMSException {
        MessageStore longtermStore = this.longTermPersistence.createQueueMessageStore(destinationName);
        CacheMessageStore store = new CacheMessageStore(this, longtermStore, this.createMessageCache(destinationName));
        return store;
    }

    public TopicMessageStore createTopicMessageStore(String destinationName) throws JMSException {
        TopicMessageStore longtermStore = this.longTermPersistence.createTopicMessageStore(destinationName);
        CacheTopicMessageStore store = new CacheTopicMessageStore(this, longtermStore, (MessageCache)new SimpleMessageCache());
        return store;
    }

    public TransactionStore createTransactionStore() throws JMSException {
        return this.longTermPersistence.createTransactionStore();
    }

    public void beginTransaction() throws JMSException {
        this.longTermPersistence.beginTransaction();
    }

    public void commitTransaction() throws JMSException {
        this.longTermPersistence.commitTransaction();
    }

    public void rollbackTransaction() {
        this.longTermPersistence.rollbackTransaction();
    }

    public void start() throws JMSException {
        this.longTermPersistence.start();
    }

    public void stop() throws JMSException {
        this.longTermPersistence.stop();
    }

    public PersistenceAdapter getLongTermPersistence() {
        return this.longTermPersistence;
    }

    public void setLongTermPersistence(PersistenceAdapter longTermPersistence) {
        this.longTermPersistence = longTermPersistence;
    }

    protected abstract MessageCache createMessageCache(String var1);
}

