/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.multicast;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.JMSException;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.message.ActiveMQTextMessage;
import org.activemq.message.Packet;
import org.activemq.message.PacketListener;
import org.activemq.transport.multicast.MulticastTransportChannel;
import org.activemq.util.IdGenerator;

public class MulticastTester
implements PacketListener {
    private static final IdGenerator idGenerator = new IdGenerator();
    public static final String DEFAULT_DISCOVERY_URI = "multicast://224.1.2.3:6066";
    private SynchronizedBoolean started = new SynchronizedBoolean(false);
    private MulticastTransportChannel channel;
    private URI uri;
    private String localId = idGenerator.generateId();

    public static void main(String[] args) throws URISyntaxException, JMSException, InterruptedException {
        MulticastTester tester = new MulticastTester();
        tester.setUri(new URI(DEFAULT_DISCOVERY_URI));
        if (args.length > 0) {
            tester.setUri(new URI(args[0]));
        }
        if (args.length > 1) {
            tester.setLocalId(args[1]);
        }
        tester.start();
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        int counter = 0;
        while (true) {
            message.setText("Message " + counter + " from " + tester.getLocalId());
            tester.send(message);
            ++counter;
            Thread.sleep(1000L);
        }
    }

    private void send(ActiveMQTextMessage message) throws JMSException {
        this.channel.asyncSend(message);
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            System.out.println("Opening: " + this.uri);
            this.channel = new MulticastTransportChannel((WireFormat)new DefaultWireFormat(), this.uri);
            this.channel.setClientID(this.localId);
            this.channel.setPacketListener(this);
            this.channel.start();
        }
    }

    public void stop() throws JMSException {
        if (this.started.commit(true, false)) {
            this.channel.stop();
        }
    }

    public void consume(Packet packet) {
        if (packet instanceof ActiveMQTextMessage) {
            try {
                System.out.println("Received Text Packet: " + ((ActiveMQTextMessage)packet).getText());
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Received Unknown Packet: " + packet);
        }
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }
}

