/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.tcp;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import javax.jms.JMSException;
import org.activemq.io.WireFormat;
import org.activemq.io.WireFormatLoader;
import org.activemq.message.Packet;
import org.activemq.transport.TransportChannelSupport;
import org.activemq.transport.TransportStatusEvent;
import org.activemq.transport.tcp.TcpBufferedOutputStream;
import org.activemq.transport.tcp.TcpTransportServerChannel;
import org.activemq.util.JMSExceptionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpTransportChannel
extends TransportChannelSupport
implements Runnable {
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 65536;
    private static final Log log = LogFactory.getLog((Class)TcpTransportChannel.class);
    protected Socket socket;
    protected DataOutputStream dataOut;
    protected DataInputStream dataIn;
    private WireFormatLoader wireFormatLoader;
    private SynchronizedBoolean closed;
    private SynchronizedBoolean started;
    private Object outboundLock;
    private Executor executor;
    private Thread thread;
    private boolean useAsyncSend = false;
    private int soTimeout = 10000;
    private int socketBufferSize = 65536;
    private BoundedChannel exceptionsList;
    private TcpTransportServerChannel serverChannel;

    protected TcpTransportChannel(WireFormat wireFormat) {
        super(wireFormat);
        this.wireFormatLoader = new WireFormatLoader(wireFormat);
        this.closed = new SynchronizedBoolean(false);
        this.started = new SynchronizedBoolean(false);
        this.exceptionsList = new BoundedLinkedQueue(10);
        this.outboundLock = new Object();
        this.setUseAsyncSend(this.useAsyncSend);
        super.setCachingEnabled(true);
    }

    public TcpTransportChannel(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        this(wireFormat);
        try {
            this.socket = this.createSocket(remoteLocation);
            this.initializeStreams();
        }
        catch (Exception ioe) {
            throw JMSExceptionHelper.newJMSException("Initialization of TcpTransportChannel failed. URI was: " + remoteLocation + " Reason: " + ioe, ioe);
        }
    }

    public TcpTransportChannel(WireFormat wireFormat, URI remoteLocation, URI localLocation) throws JMSException {
        this(wireFormat);
        try {
            this.socket = this.createSocket(remoteLocation, localLocation);
            this.initializeStreams();
        }
        catch (Exception ioe) {
            throw JMSExceptionHelper.newJMSException("Initialization of TcpTransportChannel failed: " + ioe, ioe);
        }
    }

    public TcpTransportChannel(TcpTransportServerChannel serverChannel, WireFormat wireFormat, Socket socket, Executor executor) throws JMSException {
        this(wireFormat);
        this.socket = socket;
        this.executor = executor;
        this.serverChannel = serverChannel;
        this.setServerSide(true);
        try {
            this.initialiseSocket(socket);
            this.initializeStreams();
        }
        catch (IOException ioe) {
            throw JMSExceptionHelper.newJMSException("Initialization of TcpTransportChannel failed: " + ioe, ioe);
        }
    }

    public TcpTransportChannel(WireFormat wireFormat, Socket socket, Executor executor) throws JMSException {
        this(wireFormat);
        this.socket = socket;
        this.executor = executor;
        try {
            this.initialiseSocket(socket);
            this.initializeStreams();
        }
        catch (IOException ioe) {
            throw JMSExceptionHelper.newJMSException("Initialization of TcpTransportChannel failed: " + ioe, ioe);
        }
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            this.thread = new Thread((Runnable)this, this.toString());
            try {
                if (this.isServerSide()) {
                    this.thread.setDaemon(true);
                    WireFormat wf = this.wireFormatLoader.getWireFormat(this.dataIn);
                    if (wf != null) {
                        this.setWireFormat(wf);
                    }
                    this.getWireFormat().registerTransportStreams(this.dataOut, this.dataIn);
                    this.getWireFormat().initiateServerSideProtocol();
                } else {
                    this.getWireFormat().registerTransportStreams(this.dataOut, this.dataIn);
                    this.thread.setPriority(7);
                }
                this.currentWireFormat.setCachingEnabled(this.isCachingEnabled());
                this.thread.start();
                if (!this.isServerSide()) {
                    this.getWireFormat().initiateClientSideProtocol();
                }
                this.fireStatusEvent(new TransportStatusEvent(this, 1));
            }
            catch (EOFException e) {
                this.doClose(e);
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException("start failed: " + e.getMessage());
                jmsEx.initCause((Throwable)e);
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
        }
    }

    public void stop() {
        if (this.closed.commit(false, true)) {
            super.stop();
            try {
                if (this.executor != null) {
                    this.stopExecutor(this.executor);
                }
                this.closeStreams();
                this.socket.close();
            }
            catch (Exception e) {
                log.warn((Object)("Caught while closing: " + e + ". Now Closed"), (Throwable)e);
            }
        }
        this.closed.set(true);
        if (this.serverChannel != null) {
            this.serverChannel.removeClient(this);
        }
    }

    public void forceDisconnect() {
        log.debug((Object)"Forcing disconnect");
        if (this.socket != null && this.socket.isConnected()) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void asyncSend(final Packet packet) throws JMSException {
        if (this.executor != null) {
            try {
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            if (!TcpTransportChannel.this.isClosed()) {
                                TcpTransportChannel.this.doAsyncSend(packet);
                            }
                        }
                        catch (JMSException e) {
                            try {
                                TcpTransportChannel.this.exceptionsList.put((Object)e);
                            }
                            catch (InterruptedException e1) {
                                log.warn((Object)("Failed to add element to exception list: " + e1));
                            }
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                log.info((Object)("Caught: " + e), (Throwable)e);
            }
            try {
                JMSException e = (JMSException)((Object)this.exceptionsList.poll(0L));
                if (e != null) {
                    throw e;
                }
            }
            catch (InterruptedException e1) {
                log.warn((Object)("Failed to remove element to exception list: " + e1));
            }
        } else {
            this.doAsyncSend(packet);
        }
    }

    public boolean isMulticast() {
        return false;
    }

    public void run() {
        log.trace((Object)"TCP consumer thread starting");
        int count = 0;
        while (!this.isClosed()) {
            if (this.isServerSide() && ++count > 500) {
                count = 0;
                Thread.yield();
            }
            try {
                Packet packet = this.getWireFormat().readPacket(this.dataIn);
                if (packet == null) continue;
                this.doConsumePacket(packet);
            }
            catch (SocketTimeoutException e) {
            }
            catch (InterruptedIOException e) {
            }
            catch (IOException e) {
                this.doClose(e);
            }
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public String toString() {
        return "TcpTransportChannel: " + this.socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean canProcessWireFormatVersion(int version) {
        return this.getWireFormat().canProcessWireFormatVersion(version);
    }

    public int getCurrentWireFormatVersion() {
        return this.getWireFormat().getCurrentWireFormatVersion();
    }

    public boolean isUseAsyncSend() {
        return this.useAsyncSend;
    }

    public void setUseAsyncSend(boolean useAsyncSend) {
        this.useAsyncSend = useAsyncSend;
        try {
            if (useAsyncSend && this.executor == null) {
                PooledExecutor pe = new PooledExecutor((Channel)new BoundedBuffer(10), 1);
                pe.waitWhenBlocked();
                pe.setKeepAliveTime(1000L);
                this.executor = pe;
            } else if (!useAsyncSend && this.executor != null) {
                this.stopExecutor(this.executor);
            }
        }
        catch (Exception e) {
            log.warn((Object)"problem closing executor", (Throwable)e);
        }
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) throws JMSException {
        this.soTimeout = soTimeout;
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(soTimeout);
            }
            catch (SocketException e) {
                JMSException jmsEx = new JMSException("Failed to set soTimeout: ", e.getMessage());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
        }
    }

    public void setNoDelay(boolean noDelay) {
        super.setNoDelay(noDelay);
        if (this.socket != null) {
            try {
                this.socket.setTcpNoDelay(noDelay);
            }
            catch (SocketException e) {
                log.warn((Object)"failed to set noDelay on the socket");
            }
        }
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Packet doAsyncSend(Packet packet) throws JMSException {
        Packet response = null;
        try {
            Object object = this.outboundLock;
            synchronized (object) {
                response = this.getWireFormat().writePacket(packet, this.dataOut);
                this.dataOut.flush();
            }
        }
        catch (IOException e) {
            JMSException exception = JMSExceptionHelper.newJMSException("asyncSend failed: " + e, e);
            this.onAsyncException(exception);
            throw exception;
        }
        catch (JMSException e) {
            if (this.isClosed()) {
                log.trace((Object)("Caught exception while closed: " + (Object)((Object)e)), (Throwable)e);
            }
            throw e;
        }
        return response;
    }

    protected void doClose(Exception ex) {
        if (!this.isClosed()) {
            if (!this.pendingStop) {
                this.setPendingStop(true);
                this.setTransportConnected(false);
                if (ex instanceof EOFException) {
                    if (!this.isServerSide() && !this.isUsedInternally()) {
                        log.warn((Object)"Peer closed connection", (Throwable)ex);
                    }
                    this.fireStatusEvent(new TransportStatusEvent(this, 2));
                    this.onAsyncException(JMSExceptionHelper.newJMSException("Error reading socket: " + ex, ex));
                } else {
                    this.fireStatusEvent(new TransportStatusEvent(this, 2));
                    this.onAsyncException(JMSExceptionHelper.newJMSException("Error reading socket: " + ex, ex));
                }
            }
            this.stop();
        }
    }

    protected void initialiseSocket(Socket sock) throws SocketException {
        try {
            sock.setReceiveBufferSize(this.socketBufferSize);
            sock.setSendBufferSize(this.socketBufferSize);
        }
        catch (SocketException se) {
            log.debug((Object)("Cannot set socket buffer size = " + this.socketBufferSize), (Throwable)se);
        }
        sock.setSoTimeout(this.soTimeout);
        sock.setTcpNoDelay(this.isNoDelay());
    }

    protected void initializeStreams() throws IOException {
        BufferedInputStream buffIn = new BufferedInputStream(this.socket.getInputStream(), 8192);
        this.dataIn = new DataInputStream(buffIn);
        TcpBufferedOutputStream buffOut = new TcpBufferedOutputStream(this.socket.getOutputStream(), 8192);
        this.dataOut = new DataOutputStream(buffOut);
    }

    protected void closeStreams() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.close();
        }
        if (this.dataIn != null) {
            this.dataIn.close();
        }
    }

    protected Socket createSocket(URI remoteLocation) throws UnknownHostException, IOException {
        InetSocketAddress sockAddress = new InetSocketAddress(remoteLocation.getHost(), remoteLocation.getPort());
        Socket sock = new Socket();
        this.initialiseSocket(sock);
        sock.connect(sockAddress);
        return sock;
    }

    protected Socket createSocket(URI remoteLocation, URI localLocation) throws IOException, UnknownHostException {
        InetSocketAddress sockAddress = new InetSocketAddress(remoteLocation.getHost(), remoteLocation.getPort());
        InetSocketAddress localAddress = new InetSocketAddress(InetAddress.getByName(localLocation.getHost()), localLocation.getPort());
        Socket sock = new Socket();
        this.initialiseSocket(sock);
        sock.bind(localAddress);
        sock.connect(sockAddress);
        return sock;
    }
}

