/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.synd.impl;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Guid;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.impl.ConverterForRSS093;
import java.util.List;

public class ConverterForRSS094
extends ConverterForRSS093 {
    public ConverterForRSS094() {
        this("rss_0.94");
    }

    protected ConverterForRSS094(String type) {
        super(type);
    }

    public void copyInto(WireFeed feed, SyndFeed syndFeed) {
        Channel channel = (Channel)feed;
        super.copyInto(channel, syndFeed);
        List cats = channel.getCategories();
        if (cats != null) {
            syndFeed.setCategories(this.createSyndCategories(cats));
        }
    }

    protected SyndEntry createSyndEntry(Item item) {
        SyndEntry syndEntry = super.createSyndEntry(item);
        syndEntry.setAuthor(item.getAuthor());
        Guid guid = item.getGuid();
        if (guid != null) {
            syndEntry.setUri(guid.getValue());
            if (item.getLink() == null && guid.isPermaLink()) {
                syndEntry.setLink(guid.getValue());
            }
        } else {
            syndEntry.setUri(item.getLink());
        }
        return syndEntry;
    }

    protected WireFeed createRealFeed(String type, SyndFeed syndFeed) {
        Channel channel = (Channel)super.createRealFeed(type, syndFeed);
        List cats = syndFeed.getCategories();
        if (cats != null) {
            channel.setCategories(this.createRSSCategories(cats));
        }
        return channel;
    }

    protected Item createRSSItem(SyndEntry sEntry) {
        Item item = super.createRSSItem(sEntry);
        item.setAuthor(sEntry.getAuthor());
        Guid guid = null;
        String uri = sEntry.getUri();
        if (uri != null) {
            guid = new Guid();
            guid.setPermaLink(false);
            guid.setValue(uri);
        } else {
            String link = sEntry.getLink();
            if (link != null) {
                guid = new Guid();
                guid.setPermaLink(true);
                guid.setValue(link);
            }
        }
        item.setGuid(guid);
        return item;
    }
}

