/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedGenerator;
import com.sun.syndication.io.impl.FeedGenerators;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class WireFeedOutput {
    private static final FeedGenerators GENERATORS = new FeedGenerators();

    public static List getSupportedFeedTypes() {
        return GENERATORS.getSupportedFeedTypes();
    }

    public String outputString(WireFeed feed) throws IllegalArgumentException, FeedException {
        Document doc = this.outputJDom(feed);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(doc);
    }

    public void output(WireFeed feed, File file) throws IllegalArgumentException, IOException, FeedException {
        FileWriter writer = new FileWriter(file);
        this.output(feed, writer);
        ((Writer)writer).close();
    }

    public void output(WireFeed feed, Writer writer) throws IllegalArgumentException, IOException, FeedException {
        Document doc = this.outputJDom(feed);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        outputter.output(doc, writer);
    }

    public org.w3c.dom.Document outputW3CDom(WireFeed feed) throws IllegalArgumentException, FeedException {
        Document doc = this.outputJDom(feed);
        DOMOutputter outputter = new DOMOutputter();
        try {
            return outputter.output(doc);
        }
        catch (JDOMException jdomEx) {
            throw new FeedException("Could not create DOM", jdomEx);
        }
    }

    public Document outputJDom(WireFeed feed) throws IllegalArgumentException, FeedException {
        String type = feed.getFeedType();
        WireFeedGenerator generator = GENERATORS.getGenerator(type);
        if (generator == null) {
            throw new IllegalArgumentException("Invalid feed type [" + type + "]");
        }
        if (!generator.getType().equals(type)) {
            throw new IllegalArgumentException("WireFeedOutput type[" + type + "] and WireFeed type [" + type + "] don't match");
        }
        return generator.generate(feed);
    }
}

