/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io.impl;

import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.module.DCSubject;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleGenerator;
import com.sun.syndication.io.impl.DateParser;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class DCModuleGenerator
implements ModuleGenerator {
    private static final String DC_URI = "http://purl.org/dc/elements/1.1/";
    private static final String TAXO_URI = "http://purl.org/rss/1.0/modules/taxonomy/";
    private static final String RDF_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final Namespace DC_NS = Namespace.getNamespace((String)"dc", (String)"http://purl.org/dc/elements/1.1/");
    private static final Namespace TAXO_NS = Namespace.getNamespace((String)"taxo", (String)"http://purl.org/rss/1.0/modules/taxonomy/");
    private static final Namespace RDF_NS = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    private static final Set NAMESPACES;

    public String getNamespaceUri() {
        return DC_URI;
    }

    public Set getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        List contributors;
        DCModule dcModule = (DCModule)module;
        if (dcModule.getTitle() != null) {
            element.addContent((Content)this.generateSimpleElement("title", dcModule.getTitle()));
        }
        if (dcModule.getCreator() != null) {
            element.addContent((Content)this.generateSimpleElement("creator", dcModule.getCreator()));
        }
        List subjects = dcModule.getSubjects();
        for (int i = 0; i < subjects.size(); ++i) {
            element.addContent((Content)this.generateSubjectElement((DCSubject)subjects.get(i)));
        }
        if (dcModule.getDescription() != null) {
            element.addContent((Content)this.generateSimpleElement("description", dcModule.getDescription()));
        }
        if (dcModule.getPublisher() != null) {
            element.addContent((Content)this.generateSimpleElement("publisher", dcModule.getPublisher()));
        }
        if ((contributors = dcModule.getContributors()) != null) {
            for (int i = 0; i < contributors.size(); ++i) {
                String contributor = (String)contributors.get(i);
                element.addContent((Content)this.generateSimpleElement("contributor", contributor));
            }
        }
        if (dcModule.getDate() != null) {
            element.addContent((Content)this.generateSimpleElement("date", DateParser.formatW3CDateTime(dcModule.getDate())));
        }
        if (dcModule.getType() != null) {
            element.addContent((Content)this.generateSimpleElement("type", dcModule.getType()));
        }
        if (dcModule.getFormat() != null) {
            element.addContent((Content)this.generateSimpleElement("format", dcModule.getFormat()));
        }
        if (dcModule.getIdentifier() != null) {
            element.addContent((Content)this.generateSimpleElement("identifier", dcModule.getIdentifier()));
        }
        if (dcModule.getSource() != null) {
            element.addContent((Content)this.generateSimpleElement("source", dcModule.getSource()));
        }
        if (dcModule.getLanguage() != null) {
            element.addContent((Content)this.generateSimpleElement("language", dcModule.getLanguage()));
        }
        if (dcModule.getRelation() != null) {
            element.addContent((Content)this.generateSimpleElement("relation", dcModule.getRelation()));
        }
        if (dcModule.getCoverage() != null) {
            element.addContent((Content)this.generateSimpleElement("coverage", dcModule.getCoverage()));
        }
        if (dcModule.getRights() != null) {
            element.addContent((Content)this.generateSimpleElement("rights", dcModule.getRights()));
        }
    }

    protected Element generateSubjectElement(DCSubject subject) {
        Element subjectElement = new Element("subject", DC_NS);
        if (subject.getTaxonomyUri() != null) {
            Element descriptionElement = new Element("Description", RDF_NS);
            Element topicElement = new Element("topic", TAXO_NS);
            Attribute resourceAttribute = new Attribute("resource", subject.getTaxonomyUri(), RDF_NS);
            topicElement.setAttribute(resourceAttribute);
            descriptionElement.addContent((Content)topicElement);
            if (subject.getValue() != null) {
                Element valueElement = new Element("value", RDF_NS);
                valueElement.addContent(subject.getValue());
                descriptionElement.addContent((Content)valueElement);
            }
            subjectElement.addContent((Content)descriptionElement);
        } else {
            subjectElement.addContent(subject.getValue());
        }
        return subjectElement;
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, DC_NS);
        element.addContent(value);
        return element;
    }

    static {
        HashSet<Namespace> nss = new HashSet<Namespace>();
        nss.add(DC_NS);
        nss.add(TAXO_NS);
        nss.add(RDF_NS);
        NAMESPACES = Collections.unmodifiableSet(nss);
    }
}

