/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.cciblackbox;

import com.sun.connector.cciblackbox.CciConnectionMetaDataImpl;
import com.sun.connector.cciblackbox.CciInteraction;
import com.sun.connector.cciblackbox.CciLocalTransactionImpl;
import com.sun.connector.cciblackbox.CciManagedConnection;
import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import javax.resource.spi.IllegalStateException;

public class CciConnection
implements javax.resource.cci.Connection {
    private boolean destroyed;
    private CciManagedConnection mc;

    CciConnection(CciManagedConnection mc) {
        this.mc = mc;
    }

    CciManagedConnection getManagedConnection() {
        return this.mc;
    }

    public Interaction createInteraction() throws ResourceException {
        return new CciInteraction(this);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        try {
            Connection con = this.getJdbcConnection();
            if (con.getTransactionIsolation() == 0) {
                throw new ResourceException("Local Transaction not supported!!");
            }
        }
        catch (Exception e) {
            throw new ResourceException(e.getMessage());
        }
        return new CciLocalTransactionImpl(this.mc);
    }

    public void setAutoCommit(boolean autoCommit) throws ResourceException {
        try {
            Connection con = this.getJdbcConnection();
            if (con.getTransactionIsolation() == 0) {
                throw new ResourceException("Local Transaction not supported!!");
            }
            con.setAutoCommit(autoCommit);
        }
        catch (Exception e) {
            throw new ResourceException(e.getMessage());
        }
    }

    public boolean getAutoCommit() throws ResourceException {
        boolean val = false;
        try {
            Connection con = this.getJdbcConnection();
            if (con.getTransactionIsolation() == 0) {
                throw new ResourceException("Local Transaction not supported!!");
            }
            val = con.getAutoCommit();
        }
        catch (SQLException e) {
            throw new ResourceException(e.getMessage());
        }
        return val;
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        throw new NotSupportedException("ResultSet is not supported.");
    }

    public void close() throws ResourceException {
        if (this.mc == null) {
            return;
        }
        this.mc.removeCciConnection(this);
        this.mc.sendEvent(1, null, this);
        this.mc = null;
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        return new CciConnectionMetaDataImpl(this.mc);
    }

    void associateConnection(CciManagedConnection newMc) throws ResourceException {
        try {
            this.checkIfValid();
        }
        catch (ResourceException ex) {
            throw new IllegalStateException("Connection is invalid");
        }
        this.mc.removeCciConnection(this);
        newMc.addCciConnection(this);
        this.mc = newMc;
    }

    void checkIfValid() throws ResourceException {
        if (this.mc == null) {
            throw new ResourceException("Connection is invalid");
        }
    }

    Connection getJdbcConnection() throws SQLException {
        Connection con = null;
        try {
            this.checkIfValid();
            con = this.mc.getJdbcConnection();
        }
        catch (ResourceException ex) {
            throw new SQLException("Connection is invalid.");
        }
        return con;
    }

    void invalidate() {
        this.mc = null;
    }

    private void checkIfDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException("Managed connection is closed");
        }
    }
}

