/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.cciblackbox;

import java.util.Vector;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ManagedConnection;
import javax.sql.ConnectionEventListener;

public class CciConnectionEventListener
implements ConnectionEventListener {
    private Vector listeners = new Vector();
    private ManagedConnection mcon;

    public CciConnectionEventListener(ManagedConnection mcon) {
        this.mcon = mcon;
    }

    public void sendEvent(int eventType, Exception ex, Object connectionHandle) {
        Vector list = (Vector)this.listeners.clone();
        ConnectionEvent ce = null;
        ce = ex == null ? new ConnectionEvent(this.mcon, eventType) : new ConnectionEvent(this.mcon, eventType, ex);
        if (connectionHandle != null) {
            ce.setConnectionHandle(connectionHandle);
        }
        int size = list.size();
        int i = 0;
        while (i < size) {
            javax.resource.spi.ConnectionEventListener l = (javax.resource.spi.ConnectionEventListener)list.elementAt(i);
            switch (eventType) {
                case 1: {
                    l.connectionClosed(ce);
                    break;
                }
                case 2: {
                    l.localTransactionStarted(ce);
                    break;
                }
                case 3: {
                    l.localTransactionCommitted(ce);
                    break;
                }
                case 4: {
                    l.localTransactionRolledback(ce);
                    break;
                }
                case 5: {
                    l.connectionErrorOccurred(ce);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal eventType: " + eventType);
                }
            }
            ++i;
        }
    }

    public void addConnectorListener(javax.resource.spi.ConnectionEventListener l) {
        this.listeners.addElement(l);
    }

    public void removeConnectorListener(javax.resource.spi.ConnectionEventListener l) {
        this.listeners.removeElement(l);
    }

    public void connectionClosed(javax.sql.ConnectionEvent event) {
    }

    public void connectionErrorOccurred(javax.sql.ConnectionEvent event) {
        this.sendEvent(5, event.getSQLException(), null);
    }
}

