/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.cciblackbox;

import com.sun.connector.cciblackbox.CciConnection;
import com.sun.connector.cciblackbox.CciConnectionEventListener;
import com.sun.connector.cciblackbox.CciManagedConnectionMetaDataImpl;
import com.sun.connector.cciblackbox.SpiLocalTransactionImpl;
import com.sun.connector.cciblackbox.Util;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class CciManagedConnection
implements ManagedConnection {
    private XAConnection xacon;
    private Connection con;
    private CciConnectionEventListener cciListener;
    private PasswordCredential passCred;
    private ManagedConnectionFactory mcf;
    private PrintWriter logWriter;
    private boolean supportsXA;
    private boolean supportsLocalTx;
    private boolean destroyed;
    private Set connectionSet;

    CciManagedConnection(ManagedConnectionFactory mcf, PasswordCredential passCred, XAConnection xacon, Connection con, boolean supportsXA, boolean supportsLocalTx) {
        this.mcf = mcf;
        this.passCred = passCred;
        this.xacon = xacon;
        this.con = con;
        this.supportsXA = supportsXA;
        this.supportsLocalTx = supportsLocalTx;
        this.connectionSet = new HashSet();
        this.cciListener = new CciConnectionEventListener(this);
        if (xacon != null) {
            xacon.addConnectionEventListener(this.cciListener);
        }
    }

    public void setXAConnection(XAConnection xa) {
        this.xacon = xa;
    }

    public void setConnection(Connection con) {
        this.con = con;
    }

    public void setSupportsXA(boolean xa) {
        this.supportsXA = xa;
    }

    public void setSupportsLocalTx(boolean xa) {
        this.supportsLocalTx = xa;
    }

    public void setManagedConnectionFactory(ManagedConnectionFactory xa) {
        this.mcf = xa;
    }

    public XAConnection getXAConnection() {
        return this.xacon;
    }

    public Connection getConnection() {
        return this.con;
    }

    public boolean getSupportsXA() {
        return this.supportsXA;
    }

    public boolean getSupportsLocalTx() {
        return this.supportsLocalTx;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    private void throwResourceException(SQLException ex) throws ResourceException {
        ResourceException re = new ResourceException("SQLException: " + ex.getMessage());
        re.setLinkedException((Exception)ex);
        throw re;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        PasswordCredential pc = Util.getPasswordCredential(this.mcf, subject, connectionRequestInfo);
        if (!Util.isPasswordCredentialEqual(pc, this.passCred)) {
            throw new SecurityException("Principal does not match.Reauthentication not supported");
        }
        this.checkIfDestroyed();
        CciConnection cciCon = new CciConnection(this);
        this.addCciConnection(cciCon);
        return cciCon;
    }

    public void destroy() throws ResourceException {
        try {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            Iterator it = this.connectionSet.iterator();
            while (it.hasNext()) {
                CciConnection cciCon = (CciConnection)it.next();
                cciCon.invalidate();
            }
            this.connectionSet.clear();
            this.con.close();
            if (this.xacon != null) {
                this.xacon.close();
            }
        }
        catch (SQLException ex) {
            this.throwResourceException(ex);
        }
    }

    public void cleanup() throws ResourceException {
        try {
            this.checkIfDestroyed();
            Iterator it = this.connectionSet.iterator();
            while (it.hasNext()) {
                CciConnection cciCon = (CciConnection)it.next();
                cciCon.invalidate();
            }
            this.connectionSet.clear();
            if (this.xacon != null) {
                this.con.close();
                this.con = this.xacon.getConnection();
            } else {
                this.con.setAutoCommit(true);
            }
        }
        catch (SQLException ex) {
            this.throwResourceException(ex);
        }
    }

    public void associateConnection(Object connection) throws ResourceException {
        this.checkIfDestroyed();
        if (!(connection instanceof CciConnection)) {
            throw new IllegalStateException("Invalid connection object: " + connection);
        }
        CciConnection cciCon = (CciConnection)connection;
        cciCon.associateConnection(this);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.cciListener.addConnectorListener(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.cciListener.removeConnectorListener(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        if (!this.supportsXA) {
            throw new NotSupportedException("XA transaction not supported");
        }
        try {
            this.checkIfDestroyed();
            return this.xacon.getXAResource();
        }
        catch (SQLException ex) {
            this.throwResourceException(ex);
            return null;
        }
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (!this.supportsLocalTx) {
            throw new NotSupportedException("Local transaction not supported");
        }
        this.checkIfDestroyed();
        return new SpiLocalTransactionImpl(this);
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.checkIfDestroyed();
        return new CciManagedConnectionMetaDataImpl(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public Connection getJdbcConnection() throws ResourceException {
        this.checkIfDestroyed();
        return this.con;
    }

    boolean isDestroyed() {
        return this.destroyed;
    }

    PasswordCredential getPasswordCredential() {
        return this.passCred;
    }

    public void sendEvent(int eventType, Exception ex) {
        this.cciListener.sendEvent(eventType, ex, null);
    }

    public void sendEvent(int eventType, Exception ex, Object connectionHandle) {
        this.cciListener.sendEvent(eventType, ex, connectionHandle);
    }

    public void removeCciConnection(CciConnection cciCon) {
        this.connectionSet.remove(cciCon);
    }

    public void addCciConnection(CciConnection cciCon) {
        this.connectionSet.add(cciCon);
    }

    private void checkIfDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException("Managed connection is closed");
        }
    }
}

