/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.cciblackbox;

import com.sun.connector.cciblackbox.CciConnectionFactory;
import com.sun.connector.cciblackbox.CciManagedConnection;
import com.sun.connector.cciblackbox.Util;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class CciManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    private String XADataSourceName;
    private transient Context ic;

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        return new CciConnectionFactory(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        return new CciConnectionFactory(this, null);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        try {
            XAConnection xacon = null;
            String userName = null;
            PasswordCredential pc = Util.getPasswordCredential(this, subject, info);
            if (pc == null) {
                xacon = this.getXADataSource().getXAConnection();
            } else {
                userName = pc.getUserName();
                xacon = this.getXADataSource().getXAConnection(userName, new String(pc.getPassword()));
            }
            Connection con = xacon.getConnection();
            return new CciManagedConnection(this, pc, xacon, con, true, true);
        }
        catch (SQLException ex) {
            EISSystemException re = new EISSystemException("SQLException: " + ex.getMessage());
            re.setLinkedException((Exception)ex);
            throw re;
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        PasswordCredential pc = Util.getPasswordCredential(this, subject, info);
        Iterator it = connectionSet.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof CciManagedConnection)) continue;
            CciManagedConnection mc = (CciManagedConnection)obj;
            ManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (!Util.isPasswordCredentialEqual(mc.getPasswordCredential(), pc) || !mcf.equals((Object)this)) continue;
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        try {
            this.getXADataSource().setLogWriter(out);
        }
        catch (SQLException ex) {
            ResourceException rex = new ResourceException("SQLException");
            rex.setLinkedException((Exception)ex);
            throw rex;
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        try {
            return this.getXADataSource().getLogWriter();
        }
        catch (SQLException ex) {
            ResourceException rex = new ResourceException("SQLException");
            rex.setLinkedException((Exception)ex);
            throw rex;
        }
    }

    public String getXADataSourceName() {
        return this.XADataSourceName;
    }

    public void setXADataSourceName(String XADataSourceName) {
        this.XADataSourceName = XADataSourceName;
    }

    private XADataSource getXADataSource() throws ResourceException {
        try {
            if (this.ic == null) {
                this.ic = new InitialContext();
            }
            XADataSource ds = (XADataSource)this.ic.lookup(this.XADataSourceName);
            return ds;
        }
        catch (Exception ex) {
            ResourceException rex = new ResourceException("");
            rex.setLinkedException(ex);
            throw rex;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CciManagedConnectionFactory) {
            String v1 = ((CciManagedConnectionFactory)obj).XADataSourceName;
            String v2 = this.XADataSourceName;
            return v1 == null ? v2 == null : v1.equals(v2);
        }
        return false;
    }

    public int hashCode() {
        if (this.XADataSourceName == null) {
            return new String("").hashCode();
        }
        return this.XADataSourceName.hashCode();
    }
}

