/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.cciblackbox;

import com.sun.connector.cciblackbox.CciConnectionFactory;
import com.sun.connector.cciblackbox.CciManagedConnection;
import com.sun.connector.cciblackbox.Util;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class CciNoTxManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    private String url;

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        return new CciConnectionFactory(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        return new CciConnectionFactory(this, null);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        try {
            Connection con = null;
            String userName = null;
            PasswordCredential pc = Util.getPasswordCredential(this, subject, info);
            if (pc == null) {
                con = DriverManager.getConnection(this.url);
            } else {
                userName = pc.getUserName();
                con = DriverManager.getConnection(this.url, userName, new String(pc.getPassword()));
            }
            return new CciManagedConnection(this, pc, null, con, false, false);
        }
        catch (SQLException ex) {
            EISSystemException re = new EISSystemException("SQLException: " + ex.getMessage());
            re.setLinkedException((Exception)ex);
            throw re;
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        PasswordCredential pc = Util.getPasswordCredential(this, subject, info);
        Iterator it = connectionSet.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof CciManagedConnection)) continue;
            CciManagedConnection mc = (CciManagedConnection)obj;
            ManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (!Util.isPasswordCredentialEqual(mc.getPasswordCredential(), pc) || !mcf.equals((Object)this)) continue;
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        DriverManager.setLogWriter(out);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return DriverManager.getLogWriter();
    }

    public String getConnectionURL() {
        return this.url;
    }

    public void setConnectionURL(String url) {
        this.url = url;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CciNoTxManagedConnectionFactory) {
            String v1 = ((CciNoTxManagedConnectionFactory)obj).url;
            String v2 = this.url;
            return v1 == null ? v2 == null : v1.equals(v2);
        }
        return false;
    }

    public int hashCode() {
        if (this.url == null) {
            return new String("").hashCode();
        }
        return this.url.hashCode();
    }
}

