/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.bean;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;

public class Requestor {
    private Session session;
    private Destination temporaryDestination;
    private MessageProducer sender;
    private MessageConsumer receiver;
    private long maximumTimeout = 20000L;

    public Requestor(Session session, Destination destination) throws JMSException {
        this.session = session;
        this.temporaryDestination = this.createTemporaryDestination(session);
        this.sender = session.createProducer(destination);
        this.receiver = session.createConsumer(this.temporaryDestination);
    }

    public Message request(Message message) throws JMSException {
        message.setJMSReplyTo(this.temporaryDestination);
        this.sender.send(message);
        long timeout = this.getMaximumTimeout();
        if (timeout > 0L) {
            return this.receiver.receive(timeout);
        }
        return this.receiver.receive();
    }

    public Message request(Message message, long timeout) throws JMSException {
        message.setJMSReplyTo(this.temporaryDestination);
        this.sender.send(message);
        return this.receiver.receive(timeout);
    }

    public void close() throws JMSException {
        this.session.close();
        if (this.temporaryDestination instanceof TemporaryQueue) {
            ((TemporaryQueue)this.temporaryDestination).delete();
        } else if (this.temporaryDestination instanceof TemporaryTopic) {
            ((TemporaryTopic)this.temporaryDestination).delete();
        }
    }

    public long getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public void setMaximumTimeout(long maximumTimeout) {
        this.maximumTimeout = maximumTimeout;
    }

    protected TemporaryQueue createTemporaryDestination(Session session) throws JMSException {
        return session.createTemporaryQueue();
    }
}

