/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.jca;

import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import org.activemq.jca.JCAConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public abstract class JCAContainerSupport
implements InitializingBean,
DisposableBean,
BeanFactoryAware {
    private static final transient Log log = LogFactory.getLog((Class)JCAContainerSupport.class);
    protected ResourceAdapter resourceAdapter;
    private BeanFactory beanFactory;
    private boolean lazyLoad = false;

    public JCAConnector addConnector() {
        return new JCAConnector(this.getBootstrapContext(), this.getResourceAdapter());
    }

    public void afterPropertiesSet() throws Exception {
        if (this.resourceAdapter == null) {
            throw new IllegalArgumentException("bootstrapContext must be set");
        }
        this.resourceAdapter.start(this.getBootstrapContext());
        if (this.beanFactory == null) {
            throw new IllegalArgumentException("beanFactory should have been set by Spring");
        }
        if (!this.lazyLoad && this.beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.beanFactory;
            String[] names = registry.getBeanDefinitionNames();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                BeanDefinition definition = registry.getBeanDefinition(name);
                if (definition.isAbstract()) continue;
                this.beanFactory.getBean(name);
            }
        }
        String version = null;
        Package aPackage = Package.getPackage("org.activemq.jca");
        if (aPackage != null) {
            version = aPackage.getImplementationVersion();
        }
        log.info((Object)("ActiveMQ JCA Container (http://activemq.org/) has started running version: " + version));
    }

    public void destroy() throws Exception {
        if (this.resourceAdapter != null) {
            this.resourceAdapter.stop();
        }
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
    }

    protected abstract BootstrapContext getBootstrapContext();
}

