/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.work.pool;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import org.activemq.work.pool.NullWorkExecutorPool;
import org.activemq.work.pool.WorkExecutorPool;

public class WorkExecutorPoolImpl
implements WorkExecutorPool {
    private PooledExecutor pooledExecutor;

    public WorkExecutorPoolImpl(int maxSize) {
        this.pooledExecutor = new PooledExecutor((Channel)new LinkedQueue(), maxSize);
        this.pooledExecutor.setMinimumPoolSize(maxSize);
        this.pooledExecutor.waitWhenBlocked();
    }

    public WorkExecutorPoolImpl(Channel channel, int maxSize) {
        this.pooledExecutor = new PooledExecutor(channel, maxSize);
        this.pooledExecutor.setMinimumPoolSize(maxSize);
        this.pooledExecutor.waitWhenBlocked();
    }

    public void execute(Runnable work) throws InterruptedException {
        this.pooledExecutor.execute(work);
    }

    public int getPoolSize() {
        return this.pooledExecutor.getPoolSize();
    }

    public int getMaximumPoolSize() {
        return this.pooledExecutor.getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int maxSize) {
        this.pooledExecutor.setMaximumPoolSize(maxSize);
    }

    public WorkExecutorPool start() {
        throw new IllegalStateException("This pooled executor is already started");
    }

    public WorkExecutorPool stop() {
        int maxSize = this.getMaximumPoolSize();
        this.pooledExecutor.shutdownAfterProcessingCurrentlyQueuedTasks();
        return new NullWorkExecutorPool(maxSize);
    }
}

