/*
 * Decompiled with CFR 0.152.
 */
package org.activeio;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Properties;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelFactory;
import org.activeio.AsynchChannelServer;
import org.activeio.SynchChannel;
import org.activeio.SynchChannelFactory;
import org.activeio.SynchChannelServer;
import org.activeio.adapter.AsynchToSynchChannelFactoryAdaptor;
import org.activeio.adapter.SynchToAsynchChannelFactoryAdaptor;

public class ChannelFactory
implements SynchChannelFactory,
AsynchChannelFactory {
    private final HashMap synchChannelFactoryMap = new HashMap();
    private final HashMap asynchChannelFactoryMap = new HashMap();
    public static final Executor DEFAULT_EXECUTOR = new PooledExecutor();
    private static FactoryFinder finder;

    public SynchChannel openSynchChannel(URI location) throws IOException {
        SynchChannelFactory factory = this.getSynchChannelFactory(location.getScheme());
        return factory.openSynchChannel(location);
    }

    public SynchChannelServer bindSynchChannel(URI location) throws IOException {
        SynchChannelFactory factory = this.getSynchChannelFactory(location.getScheme());
        return factory.bindSynchChannel(location);
    }

    public AsynchChannel openAsynchChannel(URI location) throws IOException {
        AsynchChannelFactory factory = this.getAsynchChannelFactory(location.getScheme());
        return factory.openAsynchChannel(location);
    }

    public AsynchChannelServer bindAsynchChannel(URI location) throws IOException {
        AsynchChannelFactory factory = this.getAsynchChannelFactory(location.getScheme());
        return factory.bindAsynchChannel(location);
    }

    private SynchChannelFactory getSynchChannelFactory(String protocol) throws IOException {
        try {
            SynchChannelFactory rc = (SynchChannelFactory)this.synchChannelFactoryMap.get(protocol);
            if (rc == null) {
                try {
                    rc = (SynchChannelFactory)finder.newInstance(protocol, "SynchChannelFactory.");
                }
                catch (Throwable original) {
                    try {
                        AsynchChannelFactory f = (AsynchChannelFactory)finder.newInstance(protocol, "AsynchChannelFactory.");
                        rc = AsynchToSynchChannelFactoryAdaptor.adapt(f);
                    }
                    catch (Throwable e) {
                        throw original;
                    }
                }
                this.synchChannelFactoryMap.put(protocol, rc);
            }
            return rc;
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Could not load a SynchChannelFactory for protcol: " + protocol + ", reason: " + e).initCause(e);
        }
    }

    private AsynchChannelFactory getAsynchChannelFactory(String protocol) throws IOException {
        try {
            AsynchChannelFactory rc = (AsynchChannelFactory)this.asynchChannelFactoryMap.get(protocol);
            if (rc == null) {
                try {
                    rc = (AsynchChannelFactory)finder.newInstance(protocol, "AsynchChannelFactory.");
                }
                catch (Throwable original) {
                    try {
                        SynchChannelFactory f = (SynchChannelFactory)finder.newInstance(protocol, "SynchChannelFactory.");
                        rc = SynchToAsynchChannelFactoryAdaptor.adapt(f);
                    }
                    catch (Throwable e) {
                        throw original;
                    }
                }
                this.asynchChannelFactoryMap.put(protocol, rc);
            }
            return rc;
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Could not load a AsynchChannelFactory for protcol: " + protocol + ", reason: " + e).initCause(e);
        }
    }

    static {
        ((PooledExecutor)DEFAULT_EXECUTOR).setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setDaemon(true);
                return thread;
            }
        });
        finder = new FactoryFinder("META-INF/org.activeio.ChannelFactory/");
    }

    private static class FactoryFinder {
        private String path;

        public FactoryFinder(String path) {
            this.path = path;
        }

        public Object newInstance(String key) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
            return this.newInstance(key, null);
        }

        public Object newInstance(String key, String propertyPrefix) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
            return this.newInstance(this.doFindFactoryProperies(key), propertyPrefix);
        }

        private Object newInstance(Properties properties, String propertyPrefix) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
            Class<?> clazz;
            String className;
            if (propertyPrefix == null) {
                propertyPrefix = "";
            }
            if ((className = properties.getProperty(propertyPrefix + "class")) == null) {
                throw new IOException("Expected property is missing: " + propertyPrefix + "class");
            }
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                clazz = this.getClass().getClassLoader().loadClass(className);
            }
            return clazz.newInstance();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties doFindFactoryProperies(String key) throws IOException, ClassNotFoundException {
            String uri = this.path + key;
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri);
            if (in == null && (in = this.getClass().getClassLoader().getResourceAsStream(uri)) == null) {
                throw new IOException("Could not find factory class for resource: " + uri);
            }
            BufferedInputStream reader = null;
            try {
                reader = new BufferedInputStream(in);
                Properties properties = new Properties();
                properties.load(reader);
                Properties properties2 = properties;
                return properties2;
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

