/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.adapter;

import java.io.IOException;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelListener;
import org.activeio.Packet;
import org.activeio.RequestChannel;
import org.activeio.RequestListener;
import org.activeio.packet.EOSPacket;

public class AsynchChannelToServerRequestChannel
implements RequestChannel,
AsynchChannelListener {
    private final AsynchChannel next;
    private RequestListener requestListener;

    public AsynchChannelToServerRequestChannel(AsynchChannel next) throws IOException {
        this.next = next;
        next.setAsynchChannelListener(this);
    }

    public Packet request(Packet request, long timeout) throws IOException {
        throw new IOException("Operation not supported.");
    }

    public void setRequestListener(RequestListener requestListener) throws IOException {
        this.requestListener = requestListener;
    }

    public RequestListener getRequestListener() {
        return this.requestListener;
    }

    public Object narrow(Class target) {
        return this.next.narrow(target);
    }

    public void dispose() {
        this.next.dispose();
    }

    public void start() throws IOException {
        this.next.start();
    }

    public void stop(long timeout) throws IOException {
        this.next.stop(timeout);
    }

    public void onPacket(Packet packet) {
        if (packet == EOSPacket.EOS_PACKET) {
            return;
        }
        try {
            Packet response = this.requestListener.onRequest(packet);
            this.next.write(response);
            this.next.flush();
        }
        catch (IOException e) {
            this.requestListener.onRquestError(e);
        }
    }

    public void onPacketError(IOException error) {
        this.requestListener.onRquestError(error);
    }
}

