/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.adapter;

import java.io.IOException;
import java.io.OutputStream;
import org.activeio.Packet;
import org.activeio.packet.AppendedPacket;
import org.activeio.packet.ByteArrayPacket;

public final class PacketByteArrayOutputStream
extends OutputStream {
    private Packet result;
    private Packet current;
    int nextAllocationSize = 0;

    public PacketByteArrayOutputStream() {
        this(1024);
    }

    public PacketByteArrayOutputStream(int initialSize) {
        this.nextAllocationSize = initialSize;
        this.current = this.allocate();
    }

    protected Packet allocate() {
        ByteArrayPacket packet = new ByteArrayPacket(new byte[this.nextAllocationSize]);
        this.nextAllocationSize <<= 3;
        return packet;
    }

    public void skip(int size) {
        while (size > 0) {
            if (!this.current.hasRemaining()) {
                this.allocatedNext();
            }
            int skip = size <= this.current.remaining() ? size : this.current.remaining();
            this.current.position(this.current.position() + skip);
            size -= skip;
        }
    }

    public void write(int b) throws IOException {
        if (!this.current.hasRemaining()) {
            this.allocatedNext();
        }
        this.current.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            if (!this.current.hasRemaining()) {
                this.allocatedNext();
            }
            int wrote = this.current.write(b, off, len);
            off += wrote;
            len -= wrote;
        }
    }

    private void allocatedNext() {
        if (this.result == null) {
            this.current.flip();
            this.result = this.current;
        } else {
            this.current.flip();
            this.result = AppendedPacket.join(this.result, this.current);
        }
        this.current = this.allocate();
    }

    public Packet getPacket() {
        if (this.result == null) {
            this.current.flip();
            return this.current.slice();
        }
        this.current.flip();
        return AppendedPacket.join(this.result, this.current);
    }

    public void reset() {
        this.result = null;
        this.current.clear();
    }

    public int position() {
        return this.current.position() + (this.result == null ? 0 : this.result.remaining());
    }
}

