/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.adapter;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.nio.channels.ServerSocketChannel;
import org.activeio.Channel;
import org.activeio.SynchChannel;
import org.activeio.SynchChannelServer;
import org.activeio.adapter.AsynchToSynchChannelAdapter;
import org.activeio.adapter.SynchChannelToSocketAdapter;

public class SynchChannelServerToServerSocketAdapter
extends ServerSocket {
    private final SynchChannelServer channelServer;
    private long timeout = -1L;
    boolean closed;
    private InetAddress inetAddress;
    private int localPort;
    private SocketAddress localSocketAddress;
    private int receiveBufferSize;
    private boolean reuseAddress;

    public SynchChannelServerToServerSocketAdapter(SynchChannelServer channelServer) throws IOException {
        this.channelServer = channelServer;
        URI connectURI = channelServer.getConnectURI();
        this.localPort = connectURI.getPort();
        this.inetAddress = InetAddress.getByName(connectURI.getHost());
        this.localSocketAddress = new InetSocketAddress(this.inetAddress, this.localPort);
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout <= 0 ? -1L : (long)timeout;
    }

    public synchronized int getSoTimeout() throws IOException {
        if (this.timeout == -1L) {
            return 0;
        }
        return (int)this.timeout;
    }

    public Socket accept() throws IOException {
        Channel channel = this.channelServer.accept(this.timeout);
        if (channel == null) {
            throw new InterruptedIOException();
        }
        SynchChannel synchChannel = AsynchToSynchChannelAdapter.adapt(channel);
        synchChannel.start();
        return new SynchChannelToSocketAdapter(synchChannel);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        throw new SocketException("Already bound");
    }

    public void bind(SocketAddress endpoint) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        throw new SocketException("Already bound");
    }

    public void close() throws IOException {
        if (!this.isClosed()) {
            this.channelServer.dispose();
        }
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.localSocketAddress;
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.receiveBufferSize;
    }

    public boolean getReuseAddress() throws SocketException {
        return this.reuseAddress;
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.receiveBufferSize = size;
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.reuseAddress = on;
    }
}

