/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.journal.active;

import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import org.activeio.Disposable;
import org.activeio.Packet;
import org.activeio.journal.InvalidRecordLocationException;
import org.activeio.journal.Journal;
import org.activeio.journal.JournalEventListener;
import org.activeio.journal.RecordLocation;
import org.activeio.journal.active.BatchedWrite;
import org.activeio.journal.active.Location;
import org.activeio.journal.active.LogFileManager;
import org.activeio.journal.active.Record;
import org.activeio.packet.ByteArrayPacket;
import org.activeio.packet.ByteBufferPacketPool;

public final class JournalImpl
implements Journal,
Disposable {
    public static final int DEFAULT_POOL_SIZE = Integer.parseInt(System.getProperty("org.activeio.journal.active.DefaultPoolSize", "5"));
    public static final int DEFAULT_PACKET_SIZE = Integer.parseInt(System.getProperty("org.activeio.journal.active.DefaultPacketSize", "4194304"));
    private static final int OVERFLOW_RENOTIFICATION_DELAY = 500;
    private boolean disposed = false;
    private int appendLogFileId = 0;
    private int appendLogFileOffset = 0;
    private BatchedWrite pendingBatchWrite;
    private Location lastMarkedLocation;
    private LogFileManager file;
    private QueuedExecutor executor;
    private int rolloverFence;
    private JournalEventListener eventListener;
    private ByteBufferPacketPool packetPool;
    private long overflowNotificationTime = System.currentTimeMillis();
    private Packet markPacket = new ByteArrayPacket(new byte[8]);

    public JournalImpl(File logDirectory) throws IOException {
        this(new LogFileManager(logDirectory));
    }

    public JournalImpl(File logDirectory, int logFileCount, int logFileSize) throws IOException {
        this(new LogFileManager(logDirectory, logFileCount, logFileSize));
    }

    public JournalImpl(LogFileManager logFile) {
        this.file = logFile;
        this.packetPool = new ByteBufferPacketPool(DEFAULT_POOL_SIZE, DEFAULT_PACKET_SIZE);
        this.executor = new QueuedExecutor();
        this.executor.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread answer = new Thread(runnable, "Journal Writter");
                answer.setPriority(10);
                answer.setDaemon(true);
                return answer;
            }
        });
        this.lastMarkedLocation = this.file.getLastMarkedRecordLocation();
        Location nextAppendLocation = this.file.getNextAppendLocation();
        this.appendLogFileId = nextAppendLocation.getLogFileId();
        this.appendLogFileOffset = nextAppendLocation.getLogFileOffset();
        this.rolloverFence = this.file.getInitialLogFileSize() / 10 * 9;
    }

    public RecordLocation write(Packet data, boolean sync) throws IOException {
        return this.write((byte)1, data, sync, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location write(byte recordType, Packet data, boolean sync, Location mark) throws IOException {
        try {
            BatchedWrite writeCommand;
            Location location;
            Record record = new Record(recordType, data, mark);
            JournalImpl journalImpl = this;
            synchronized (journalImpl) {
                if (this.disposed) {
                    throw new IOException("Journal has been closed.");
                }
                location = new Location(this.appendLogFileId, this.appendLogFileOffset);
                record.setLocation(location);
                writeCommand = this.addToPendingWriteBatch(record, mark, sync);
                this.appendLogFileOffset += data.limit() + 36;
                this.rolloverCheck();
            }
            if (sync) {
                writeCommand.waitForForce();
            }
            return location;
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Write failed: " + e).initCause(e);
        }
    }

    private BatchedWrite addToPendingWriteBatch(Record record, Location mark, boolean force) throws InterruptedException {
        BatchedWrite answer = null;
        while (record.hasRemaining()) {
            boolean full;
            boolean queueTheWrite = false;
            if (this.pendingBatchWrite == null) {
                this.pendingBatchWrite = new BatchedWrite(this.packetPool.getPacket());
                queueTheWrite = true;
            }
            answer = this.pendingBatchWrite;
            boolean bl = full = !this.pendingBatchWrite.append(record, mark, force);
            if (queueTheWrite) {
                final BatchedWrite queuedWrite = this.pendingBatchWrite;
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            JournalImpl.this.queuedWrite(queuedWrite);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
            if (!full) continue;
            this.pendingBatchWrite = null;
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queuedWrite(BatchedWrite write) throws InterruptedException {
        write.flip();
        try {
            this.file.append(write);
            write.forced();
        }
        catch (Throwable e) {
            write.writeFailed(e);
        }
        finally {
            write.getPacket().dispose();
        }
    }

    private void rolloverCheck() throws IOException {
        if (this.eventListener != null && this.file.isPastHalfActive() && this.overflowNotificationTime + 500L < System.currentTimeMillis()) {
            Location safeSpot = this.file.getFirstRecordLocationOfSecondActiveLogFile();
            this.eventListener.overflowNotification(safeSpot);
            this.overflowNotificationTime = System.currentTimeMillis();
        }
        if (this.appendLogFileOffset > this.rolloverFence) {
            if (!this.file.canActivateNextLogFile()) {
                this.overflowNotificationTime -= 500L;
            } else {
                final FutureResult result = new FutureResult();
                try {
                    this.executor.execute(new Runnable(){

                        public void run() {
                            try {
                                result.set((Object)JournalImpl.this.queuedActivateNextLogFile());
                            }
                            catch (Throwable e) {
                                result.setException(e);
                            }
                        }
                    });
                    Location location = (Location)result.get();
                    this.appendLogFileId = location.getLogFileId();
                    this.appendLogFileOffset = location.getLogFileOffset();
                }
                catch (InterruptedException e) {
                    throw (IOException)new IOException("Interrupted.").initCause(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof IOException) {
                        throw (IOException)new IOException(e.getTargetException().getMessage()).initCause(e.getTargetException());
                    }
                    throw (IOException)new IOException("Unexpected Exception: ").initCause(e.getTargetException());
                }
            }
        }
    }

    private Location queuedActivateNextLogFile() throws IOException {
        this.file.activateNextLogFile();
        return this.file.getNextAppendLocation();
    }

    public synchronized void setMark(RecordLocation l, boolean force) throws InvalidRecordLocationException, IOException {
        Location location = (Location)l;
        if (location == null) {
            throw new InvalidRecordLocationException("The location cannot be null.");
        }
        if (this.lastMarkedLocation != null && location.compareTo(this.lastMarkedLocation) < 0) {
            throw new InvalidRecordLocationException("The location is less than the last mark.");
        }
        this.markPacket.clear();
        location.writeToPacket(this.markPacket);
        this.markPacket.flip();
        this.write((byte)2, this.markPacket, force, location);
        this.lastMarkedLocation = location;
    }

    public RecordLocation getMark() {
        return this.lastMarkedLocation;
    }

    public RecordLocation getNextRecordLocation(final RecordLocation lastLocation) throws IOException, InvalidRecordLocationException {
        if (lastLocation == null) {
            if (this.lastMarkedLocation != null) {
                return this.lastMarkedLocation;
            }
            return this.file.getFirstActiveLogLocation();
        }
        final FutureResult result = new FutureResult();
        try {
            this.executor.execute(new Runnable(){

                public void run() {
                    try {
                        result.set((Object)JournalImpl.this.queuedGetNextRecordLocation((Location)lastLocation));
                    }
                    catch (Throwable e) {
                        result.setException(e);
                    }
                }
            });
            return (Location)result.get();
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Interrupted.").initCause(e);
        }
        catch (InvocationTargetException e) {
            return (RecordLocation)this.unwrapException(e);
        }
    }

    private Object unwrapException(InvocationTargetException e) throws InvalidRecordLocationException, IOException {
        if (e.getTargetException() instanceof InvalidRecordLocationException) {
            throw new InvalidRecordLocationException(e.getTargetException().getMessage(), e.getTargetException());
        }
        if (e.getTargetException() instanceof IOException) {
            throw (IOException)new IOException(e.getTargetException().getMessage()).initCause(e.getTargetException());
        }
        throw (IOException)new IOException("Unexpected Exception: ").initCause(e.getTargetException());
    }

    private Location queuedGetNextRecordLocation(Location location) throws IOException, InvalidRecordLocationException {
        return this.file.getNextDataRecordLocation(location);
    }

    public Packet read(RecordLocation l) throws IOException, InvalidRecordLocationException {
        final Location location = (Location)l;
        final FutureResult result = new FutureResult();
        try {
            this.executor.execute(new Runnable(){

                public void run() {
                    try {
                        result.set((Object)JournalImpl.this.file.readPacket(location));
                    }
                    catch (Throwable e) {
                        result.setException(e);
                    }
                }
            });
            return (Packet)result.get();
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Interrupted.").initCause(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof InvalidRecordLocationException) {
                throw new InvalidRecordLocationException(e.getTargetException().getMessage(), e.getTargetException());
            }
            if (e.getTargetException() instanceof IOException) {
                throw (IOException)new IOException(e.getTargetException().getMessage()).initCause(e.getTargetException());
            }
            throw (IOException)new IOException("Unexpected Exception: ").initCause(e.getTargetException());
        }
    }

    public void setJournalEventListener(JournalEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void close() throws IOException {
        this.dispose();
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.executor.shutdownAfterProcessingCurrentlyQueuedTasks();
        this.file.dispose();
    }

    public File getLogDirectory() {
        return this.file.getLogDirectory();
    }

    public int getInitialLogFileSize() {
        return this.file.getInitialLogFileSize();
    }

    public String toString() {
        return "Active Journal: using " + this.file.getOnlineLogFileCount() + " x " + (float)this.file.getInitialLogFileSize() / 1048576.0f + " Megs at: " + this.getLogDirectory();
    }
}

