/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.journal.active;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.activeio.journal.active.Location;
import org.activeio.journal.active.LogFile;

final class LogFileNode {
    public static final int SERIALIZED_SIZE = 10;
    private final LogFile logFile;
    private LogFileNode next;
    private int id;
    private boolean active = false;
    private boolean readOnly;
    private int appendOffset = 0;

    public LogFileNode(LogFile logFile) {
        this.logFile = logFile;
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public void activate(int id) {
        if (this.active) {
            throw new IllegalStateException("Log already active.");
        }
        this.id = id;
        this.readOnly = false;
        this.active = true;
        this.appendOffset = 0;
    }

    public int getId() {
        return this.id;
    }

    public void setReadOnly(boolean enable) {
        if (!this.active) {
            throw new IllegalStateException("Log not active.");
        }
        this.readOnly = enable;
    }

    public void deactivate() throws IOException {
        if (!this.active) {
            throw new IllegalStateException("Log already inactive.");
        }
        this.active = false;
        this.id = -1;
        this.readOnly = true;
        this.appendOffset = 0;
        this.getLogFile().resize();
    }

    public boolean isActive() {
        return this.active;
    }

    public int getAppendOffset() {
        return this.appendOffset;
    }

    public Location getFirstRecordLocation() {
        if (this.isActive() && this.appendOffset > 0) {
            return new Location(this.getId(), 0);
        }
        return null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void appended(int i) {
        this.appendOffset += i;
    }

    public LogFileNode getNext() {
        return this.next;
    }

    public void setNext(LogFileNode state) {
        this.next = state;
    }

    public LogFileNode getNextActive() {
        if (this.getNext().isActive()) {
            return this.getNext();
        }
        return null;
    }

    public LogFileNode getNextInactive() {
        if (!this.getNext().isActive()) {
            return this.getNext();
        }
        return null;
    }

    public void writeExternal(DataOutput data) throws IOException {
        data.writeInt(this.id);
        data.writeBoolean(this.active);
        data.writeBoolean(this.readOnly);
        data.writeInt(this.appendOffset);
    }

    public void readExternal(DataInput data) throws IOException {
        this.id = data.readInt();
        this.active = data.readBoolean();
        this.readOnly = data.readBoolean();
        this.appendOffset = data.readInt();
    }

    public void setAppendOffset(int offset) {
        this.appendOffset = offset;
    }
}

