/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.activeio.SynchChannel;
import org.activeio.SynchChannelFactory;
import org.activeio.SynchChannelServer;
import org.activeio.filter.WriteBufferedSynchChannel;
import org.activeio.net.NIOSynchChannel;
import org.activeio.net.NIOSynchChannelServer;
import org.activeio.net.URISupport;
import org.activeio.packet.ByteBufferPacket;

public class NIOSynchChannelFactory
implements SynchChannelFactory {
    protected static final int DEFAULT_BUFFER_SIZE = Integer.parseInt(System.getProperty("org.activeio.net.nio.BufferSize", "65536"));
    protected static final int DEFAULT_BACKLOG = 500;
    boolean useDirectBuffers = true;
    private final boolean createWriteBufferedChannels;
    private int backlog = 500;

    public NIOSynchChannelFactory() {
        this(true);
    }

    public NIOSynchChannelFactory(boolean createWriteBufferedChannels) {
        this.createWriteBufferedChannels = createWriteBufferedChannels;
    }

    public SynchChannel openSynchChannel(URI location) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.connect(new InetSocketAddress(location.getHost(), location.getPort()));
        return this.createSynchChannel(channel);
    }

    protected SynchChannel createSynchChannel(SocketChannel socketChannel) throws IOException {
        SynchChannel channel = new NIOSynchChannel(socketChannel);
        if (this.createWriteBufferedChannels) {
            channel = new WriteBufferedSynchChannel(channel, ByteBufferPacket.createDefaultBuffer(this.useDirectBuffers));
        }
        return channel;
    }

    public SynchChannelServer bindSynchChannel(URI bindURI) throws IOException {
        String host = bindURI.getHost();
        InetSocketAddress address = host == null || host.length() == 0 || host.equals("localhost") || host.equals("0.0.0.0") ? new InetSocketAddress(bindURI.getPort()) : new InetSocketAddress(bindURI.getHost(), bindURI.getPort());
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.socket().bind(address, this.backlog);
        URI connectURI = bindURI;
        try {
            connectURI = URISupport.changeHost(connectURI, InetAddress.getLocalHost().getHostName());
            connectURI = URISupport.changePort(connectURI, serverSocketChannel.socket().getLocalPort());
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException("Could not build connect URI: " + e).initCause(e);
        }
        return new NIOSynchChannelServer(serverSocketChannel, bindURI, connectURI, this.createWriteBufferedChannels, this.useDirectBuffers);
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }
}

