/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.nio.channels.ServerSocketChannel;
import org.activeio.Channel;
import org.activeio.SynchChannel;
import org.activeio.filter.WriteBufferedSynchChannel;
import org.activeio.net.NIOSynchChannel;
import org.activeio.net.SocketSynchChannelServer;
import org.activeio.packet.ByteBufferPacket;

public class NIOSynchChannelServer
extends SocketSynchChannelServer {
    private final boolean createWriteBufferedChannels;
    private final boolean useDirectBuffers;

    public NIOSynchChannelServer(ServerSocketChannel socketChannel, URI bindURI, URI connectURI, boolean createWriteBufferedChannels, boolean useDirectBuffers) {
        super(socketChannel.socket(), bindURI, connectURI);
        this.createWriteBufferedChannels = createWriteBufferedChannels;
        this.useDirectBuffers = useDirectBuffers;
    }

    protected Channel createChannel(Socket socket) throws IOException {
        SynchChannel channel = new NIOSynchChannel(socket.getChannel());
        if (this.createWriteBufferedChannels) {
            channel = new WriteBufferedSynchChannel(channel, ByteBufferPacket.createDefaultBuffer(this.useDirectBuffers));
        }
        return channel;
    }
}

