/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.oneport;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.activeio.AcceptListener;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelListener;
import org.activeio.AsynchChannelServer;
import org.activeio.Channel;
import org.activeio.FilterAsynchChannel;
import org.activeio.FilterAsynchChannelServer;
import org.activeio.OutputChannel;
import org.activeio.Packet;
import org.activeio.SynchChannel;
import org.activeio.adapter.AsynchToSynchChannelAdapter;
import org.activeio.adapter.SynchToAsynchChannelAdapter;
import org.activeio.filter.PushbackSynchChannel;
import org.activeio.oneport.ProtocolRecognizer;
import org.activeio.oneport.UnknownRecognizer;
import org.activeio.packet.AppendedPacket;

public final class OnePortAsynchChannelServer
extends FilterAsynchChannelServer {
    private final ConcurrentHashMap recognizerMap = new ConcurrentHashMap();

    public OnePortAsynchChannelServer(AsynchChannelServer server) throws IOException {
        super(server);
        super.setAcceptListener(new OnePortAcceptListener());
    }

    public void setAcceptListener(AcceptListener acceptListener) {
        throw new IllegalAccessError("Not supported");
    }

    public AsynchChannelServer bindAsynchChannel(ProtocolRecognizer recognizer) throws IOException {
        if (this.recognizerMap.contains((Object)recognizer)) {
            throw new IOException("That recognizer is allredy bound.");
        }
        SubPortAsynchChannelServer server = new SubPortAsynchChannelServer(recognizer);
        Object old = this.recognizerMap.put((Object)recognizer, (Object)server);
        return server;
    }

    private final class SubPortAsynchChannelServer
    implements AsynchChannelServer {
        private final ProtocolRecognizer recognizer;
        private AcceptListener acceptListener;
        private boolean started;

        public SubPortAsynchChannelServer(ProtocolRecognizer recognizer) {
            this.recognizer = recognizer;
        }

        public void setAcceptListener(AcceptListener acceptListener) {
            this.acceptListener = acceptListener;
        }

        public URI getBindURI() {
            return OnePortAsynchChannelServer.this.next.getBindURI();
        }

        public URI getConnectURI() {
            return OnePortAsynchChannelServer.this.next.getConnectURI();
        }

        public void dispose() {
            this.started = false;
            OnePortAsynchChannelServer.this.recognizerMap.remove((Object)this.recognizer);
        }

        public void start() throws IOException {
            this.started = true;
        }

        public void stop(long timeout) throws IOException {
            this.started = false;
        }

        void onAccept(Channel channel) {
            if (this.started && this.acceptListener != null) {
                this.acceptListener.onAccept(channel);
            } else {
                channel.dispose();
            }
        }

        public Object narrow(Class target) {
            if (target.isAssignableFrom(this.getClass())) {
                return this;
            }
            return OnePortAsynchChannelServer.this.narrow(target);
        }
    }

    private final class ProtocolInspectingAsynchChannel
    extends FilterAsynchChannel {
        private Packet buffer;

        public ProtocolInspectingAsynchChannel(AsynchChannel next) throws IOException {
            super(next);
            this.setAsynchChannelListener(new AsynchChannelListener(){

                public void onPacket(Packet packet) {
                    if (buffer == null) {
                        buffer = packet;
                    } else {
                        buffer = AppendedPacket.join(buffer, packet);
                    }
                    this.findMagicNumber();
                }

                public void onPacketError(IOException error) {
                    this.dispose();
                }
            });
        }

        private void findMagicNumber() {
            Iterator iter = OnePortAsynchChannelServer.this.recognizerMap.keySet().iterator();
            while (iter.hasNext()) {
                SubPortAsynchChannelServer onePort;
                ProtocolRecognizer recognizer = (ProtocolRecognizer)iter.next();
                if (!recognizer.recognizes(this.buffer.duplicate())) continue;
                if (UnknownRecognizer.UNKNOWN_RECOGNIZER == recognizer) {
                    this.dispose();
                }
                if ((onePort = (SubPortAsynchChannelServer)OnePortAsynchChannelServer.this.recognizerMap.get((Object)recognizer)) == null) {
                    this.dispose();
                }
                try {
                    this.stop(0L);
                    this.setAsynchChannelListener(null);
                }
                catch (IOException e) {
                    this.getAsynchChannelListener().onPacketError(e);
                }
                OutputChannel channel = this.getNext();
                channel = AsynchToSynchChannelAdapter.adapt(channel);
                channel = new PushbackSynchChannel((SynchChannel)channel, this.buffer);
                channel = SynchToAsynchChannelAdapter.adapt(channel);
                onePort.onAccept(channel);
                break;
            }
        }
    }

    private final class OnePortAcceptListener
    implements AcceptListener {
        private OnePortAcceptListener() {
        }

        public void onAccept(Channel channel) {
            try {
                AsynchChannel asynchChannel = SynchToAsynchChannelAdapter.adapt(channel);
                ProtocolInspectingAsynchChannel inspector = new ProtocolInspectingAsynchChannel(asynchChannel);
                inspector.start();
            }
            catch (IOException e) {
                this.onAcceptError(e);
            }
        }

        public void onAcceptError(IOException error) {
            OnePortAsynchChannelServer.this.dispose();
        }
    }
}

