/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.vote;

import java.util.Iterator;
import java.util.List;
import net.sf.acegisecurity.AccessDecisionManager;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.vote.AccessDecisionVoter;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractAccessDecisionManager
implements AccessDecisionManager,
InitializingBean {
    private List decisionVoters;
    private boolean allowIfAllAbstainDecisions = false;

    public void setAllowIfAllAbstainDecisions(boolean allowIfAllAbstainDecisions) {
        this.allowIfAllAbstainDecisions = allowIfAllAbstainDecisions;
    }

    public boolean isAllowIfAllAbstainDecisions() {
        return this.allowIfAllAbstainDecisions;
    }

    public void setDecisionVoters(List newList) {
        this.checkIfValidList(newList);
        Iterator iter = newList.iterator();
        while (iter.hasNext()) {
            Object currentObject = null;
            try {
                currentObject = iter.next();
                AccessDecisionVoter attemptToCast = (AccessDecisionVoter)currentObject;
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("AccessDecisionVoter " + currentObject.getClass().getName() + " must implement AccessDecisionVoter");
            }
        }
        this.decisionVoters = newList;
    }

    public List getDecisionVoters() {
        return this.decisionVoters;
    }

    public void afterPropertiesSet() throws Exception {
        this.checkIfValidList(this.decisionVoters);
    }

    public boolean supports(ConfigAttribute attribute) {
        Iterator iter = this.decisionVoters.iterator();
        while (iter.hasNext()) {
            AccessDecisionVoter voter = (AccessDecisionVoter)iter.next();
            if (!voter.supports(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean supports(Class clazz) {
        Iterator iter = this.decisionVoters.iterator();
        while (iter.hasNext()) {
            AccessDecisionVoter voter = (AccessDecisionVoter)iter.next();
            if (voter.supports(clazz)) continue;
            return false;
        }
        return true;
    }

    private void checkIfValidList(List listToCheck) {
        if (listToCheck == null || listToCheck.size() == 0) {
            throw new IllegalArgumentException("A list of AccessDecisionVoters is required");
        }
    }
}

