/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.AccumulateMonitorInterface;
import com.jamonapi.NullAccumulateMonitor;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;

public class AccumulateMonitor
implements AccumulateMonitorInterface {
    protected static final String TOTAL = "Total";
    protected static final String MIN = "Min";
    protected static final String MAX = "Max";
    protected static final String HITS = "Hits";
    protected static final String AVG = "Avg";
    protected static final String STANDARD_DEVIATION = "Std Dev";
    protected static final String ACTIVE = "Active";
    protected static final String AVGACTIVE = "Avg Active";
    protected static final String MAXACTIVE = "Max Active";
    protected long accrued;
    private AccumulateMonitorInterface childMonitor;
    private boolean primary;
    protected static final String MILLISECONDS = "ms.";
    protected static final String NONE = "";

    public synchronized long getAccrued() {
        return this.accrued;
    }

    public AccumulateMonitor() {
        this(NullAccumulateMonitor.createInstance());
    }

    public AccumulateMonitor(AccumulateMonitorInterface accumulateMonitorInterface) {
        this.childMonitor = accumulateMonitorInterface;
    }

    protected synchronized void resetThis() {
        this.accrued = 0L;
    }

    public void increase(long l) {
        this.increaseThis(l);
        this.childMonitor.increase(l);
    }

    public void increase() {
        this.increase(1L);
    }

    public void reset() {
        this.resetThis();
        this.childMonitor.reset();
    }

    public String toString() {
        return String.valueOf(this.toStringThis()) + this.toStringChild();
    }

    public String getUnits() {
        return NONE;
    }

    public String getType() {
        return NONE;
    }

    public void getData(ArrayList arrayList) {
        this.getDataThis(arrayList);
        this.childMonitor.getData(arrayList);
    }

    public void start() {
        this.startThis();
        this.childMonitor.start();
    }

    protected void startThis() {
    }

    public void stop() {
        this.childMonitor.stop();
        this.stopThis();
    }

    protected void stopThis() {
    }

    public String getAccruedString() {
        return AccumulateMonitor.convertToString(this.getAccrued());
    }

    protected void getDataThis(ArrayList arrayList) {
        arrayList.add(this.getAccruedString());
    }

    protected synchronized String toStringThis() {
        return this.getDisplayString(this.getType(), this.getAccruedString(), this.getUnits());
    }

    protected String toStringChild() {
        return this.childMonitor.toString();
    }

    protected static String convertToString(double d) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance();
        decimalFormat.applyPattern("#,###.#");
        return decimalFormat.format(d);
    }

    protected String getDisplayString(String string, String string2, String string3) {
        return String.valueOf(string) + "=" + string2 + " " + string3 + " ";
    }

    protected synchronized void increaseThis(long l) {
        this.accrued += l;
    }

    public void getHeader(ArrayList arrayList) {
        this.getHeaderThis(arrayList);
        this.childMonitor.getHeader(arrayList);
    }

    protected void getHeaderThis(ArrayList arrayList) {
        arrayList.add(String.valueOf(this.getType()) + " " + this.getUnits());
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean bl) {
        this.primary = bl;
        this.childMonitor.setPrimary(bl);
    }

    public static void main(String[] stringArray) throws Exception {
        AccumulateMonitor accumulateMonitor = new AccumulateMonitor();
        System.out.println("0=" + accumulateMonitor);
        accumulateMonitor.increase(25);
        System.out.println("25=" + accumulateMonitor);
        accumulateMonitor.increase(50);
        System.out.println("75=" + accumulateMonitor);
        accumulateMonitor.reset();
        System.out.println("0=" + accumulateMonitor);
        accumulateMonitor.increase(1000);
        System.out.println("1000=" + accumulateMonitor);
    }
}

