/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.ra;

import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.resource.ResourceException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.activemq.ActiveMQConnection;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQTopic;
import org.activemq.ra.ActiveMQActivationSpec;
import org.activemq.ra.ActiveMQBaseEndpointWorker;
import org.activemq.ra.ActiveMQEndpointActivationKey;
import org.activemq.ra.ActiveMQResourceAdapter;
import org.activemq.ra.ServerSessionPoolImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQAsfEndpointWorker
extends ActiveMQBaseEndpointWorker {
    private static final Log log = LogFactory.getLog((Class)ActiveMQAsfEndpointWorker.class);
    private static final long INITIAL_RECONNECT_DELAY = 1000L;
    private static final long MAX_RECONNECT_DELAY = 30000L;
    private static final ThreadLocal threadLocal = new ThreadLocal();
    private ConnectionConsumer consumer;
    private ServerSessionPoolImpl serverSessionPool;
    private ActiveMQDestination dest;
    private boolean running;
    private Work connectWork;
    protected ActiveMQConnection connection;
    private long reconnectDelay = 1000L;

    public ActiveMQAsfEndpointWorker(final ActiveMQResourceAdapter adapter, ActiveMQEndpointActivationKey key) throws ResourceException {
        super(adapter, key);
        this.connectWork = new Work(){

            public void release() {
            }

            public synchronized void run() {
                if (!ActiveMQAsfEndpointWorker.this.isRunning()) {
                    return;
                }
                if (ActiveMQAsfEndpointWorker.this.connection != null) {
                    return;
                }
                ActiveMQActivationSpec activationSpec = ActiveMQAsfEndpointWorker.this.endpointActivationKey.getActivationSpec();
                try {
                    ActiveMQAsfEndpointWorker.this.connection = adapter.makeConnection(activationSpec);
                    ActiveMQAsfEndpointWorker.this.connection.start();
                    ActiveMQAsfEndpointWorker.this.connection.setExceptionListener(new ExceptionListener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void onException(JMSException error) {
                            ActiveMQAsfEndpointWorker.access$200(1.access$100(this.this$1), error);
                        }
                    });
                    if (activationSpec.isDurableSubscription()) {
                        ActiveMQAsfEndpointWorker.this.consumer = ActiveMQAsfEndpointWorker.this.connection.createDurableConnectionConsumer((Topic)ActiveMQAsfEndpointWorker.this.dest, activationSpec.getSubscriptionName(), ActiveMQAsfEndpointWorker.this.emptyToNull(activationSpec.getMessageSelector()), (ServerSessionPool)ActiveMQAsfEndpointWorker.this.serverSessionPool, activationSpec.getMaxMessagesPerSessionsIntValue(), activationSpec.getNoLocalBooleanValue());
                    } else {
                        ActiveMQAsfEndpointWorker.this.consumer = ActiveMQAsfEndpointWorker.this.connection.createConnectionConsumer((Destination)ActiveMQAsfEndpointWorker.this.dest, ActiveMQAsfEndpointWorker.this.emptyToNull(activationSpec.getMessageSelector()), (ServerSessionPool)ActiveMQAsfEndpointWorker.this.serverSessionPool, activationSpec.getMaxMessagesPerSessionsIntValue(), activationSpec.getNoLocalBooleanValue());
                    }
                }
                catch (JMSException error) {
                    ActiveMQAsfEndpointWorker.this.reconnect(error);
                }
            }

            static /* synthetic */ ActiveMQAsfEndpointWorker access$100(1 x0) {
                return x0.ActiveMQAsfEndpointWorker.this;
            }
        };
        ActiveMQActivationSpec activationSpec = this.endpointActivationKey.getActivationSpec();
        if ("javax.jms.Queue".equals(activationSpec.getDestinationType())) {
            this.dest = new ActiveMQQueue(activationSpec.getDestination());
        } else if ("javax.jms.Topic".equals(activationSpec.getDestinationType())) {
            this.dest = new ActiveMQTopic(activationSpec.getDestination());
        } else {
            throw new ResourceException("Unknown destination type: " + activationSpec.getDestinationType());
        }
    }

    public synchronized void start() throws WorkException, ResourceException {
        if (this.running) {
            return;
        }
        this.running = true;
        log.debug((Object)"Starting");
        this.serverSessionPool = new ServerSessionPoolImpl(this, this.endpointActivationKey.getActivationSpec().getMaxSessionsIntValue());
        this.connect();
        log.debug((Object)"Started");
    }

    public synchronized void stop() throws InterruptedException {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.serverSessionPool.close();
        this.disconnect();
    }

    private boolean isRunning() {
        return this.running;
    }

    private synchronized void connect() {
        if (!this.running) {
            return;
        }
        try {
            this.workManager.scheduleWork(this.connectWork, Long.MAX_VALUE, null, null);
        }
        catch (WorkException e) {
            this.running = false;
            log.error((Object)"Work Manager did not accept work: ", (Throwable)e);
        }
    }

    private synchronized void disconnect() {
        ActiveMQAsfEndpointWorker.safeClose(this.consumer);
        this.consumer = null;
        ActiveMQAsfEndpointWorker.safeClose((Connection)this.connection);
        this.connection = null;
    }

    private synchronized void reconnect(JMSException error) {
        log.debug((Object)"Reconnect cause: ", (Throwable)error);
        if (this.reconnectDelay == 30000L) {
            log.info((Object)("Endpoint connection to JMS broker failed: " + error.getMessage()));
            log.info((Object)"Endpoint will try to reconnect to the JMS broker in 30 seconds");
        }
        try {
            this.disconnect();
            Thread.sleep(this.reconnectDelay);
            this.reconnectDelay *= 2L;
            if (this.reconnectDelay > 30000L) {
                this.reconnectDelay = 30000L;
            }
            this.connect();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void registerThreadSession(Session session) {
        threadLocal.set(session);
    }

    protected void unregisterThreadSession(Session session) {
        threadLocal.set(null);
    }

    private String emptyToNull(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }
}

