/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.ra;

import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.work.Work;
import org.activemq.ActiveMQSession;
import org.activemq.message.ActiveMQMessage;
import org.activemq.ra.ActiveMQBaseEndpointWorker;
import org.activemq.ra.CircularQueue;
import org.activemq.ra.SessionAndProducer;
import org.activemq.ra.SessionAndProducerHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InboundEndpointWork
implements SessionAndProducer,
Work {
    private static final Log log = LogFactory.getLog((Class)InboundEndpointWork.class);
    private final ActiveMQSession session;
    private final MessageEndpoint endpoint;
    private final CircularQueue workers;
    private MessageProducer messageProducer;
    private ActiveMQMessage message;

    public InboundEndpointWork(ActiveMQSession session, MessageEndpoint endpoint, CircularQueue workers) throws JMSException {
        this.session = session;
        this.endpoint = endpoint;
        this.workers = workers;
        session.setMessageListener((MessageListener)endpoint);
    }

    public Session getSession() {
        return this.session;
    }

    public MessageProducer getMessageProducer() throws JMSException {
        if (this.messageProducer == null) {
            this.messageProducer = this.getSession().createProducer(null);
        }
        return this.messageProducer;
    }

    public ActiveMQMessage getMessage() {
        return this.message;
    }

    public void setMessage(ActiveMQMessage message) {
        this.message = message;
    }

    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            SessionAndProducerHelper.register(this);
            this.endpoint.beforeDelivery(ActiveMQBaseEndpointWorker.ON_MESSAGE_METHOD);
            try {
                this.session.dispatch(this.message);
                this.session.run();
            }
            finally {
                this.endpoint.afterDelivery();
                SessionAndProducerHelper.unregister(this);
            }
        }
        catch (NoSuchMethodException e) {
            log.info((Object)"worker: ", (Throwable)e);
        }
        catch (ResourceException e) {
            log.info((Object)"worker: ", (Throwable)e);
        }
        finally {
            this.workers.returnObject(this);
        }
    }
}

