/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.ra;

import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.activemq.ActiveMQQueueSession;
import org.activemq.ActiveMQSession;
import org.activemq.ActiveMQTopicSession;
import org.activemq.TransactionContext;
import org.activemq.ra.ActiveMQManagedConnection;
import org.activemq.ra.JMSSessionProxy;
import org.activemq.ra.RATransactionContext;

public class JMSConnectionProxy
implements Connection,
QueueConnection,
TopicConnection,
ExceptionListener {
    private ActiveMQManagedConnection managedConnection;
    private ArrayList sessions = new ArrayList();
    private ExceptionListener exceptionListener;

    public JMSConnectionProxy(ActiveMQManagedConnection managedConnection) {
        this.managedConnection = managedConnection;
    }

    public void close() throws JMSException {
        if (this.managedConnection != null) {
            this.managedConnection.proxyClosedEvent(this);
        }
    }

    public void cleanup() {
        this.exceptionListener = null;
        this.managedConnection = null;
        Iterator iter = this.sessions.iterator();
        while (iter.hasNext()) {
            JMSSessionProxy p = (JMSSessionProxy)iter.next();
            try {
                p.cleanup();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            iter.remove();
        }
    }

    private Connection getConnection() throws JMSException {
        if (this.managedConnection == null) {
            throw new IllegalStateException("The Connection is closed");
        }
        return this.managedConnection.getPhysicalConnection();
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createSessionProxy(transacted, acknowledgeMode);
    }

    private JMSSessionProxy createSessionProxy(boolean transacted, int acknowledgeMode) throws JMSException {
        ActiveMQSession session = (ActiveMQSession)this.getConnection().createSession(transacted, acknowledgeMode);
        RATransactionContext txContext = new RATransactionContext(this.managedConnection.getTransactionContext());
        session.setTransactionContext((TransactionContext)txContext);
        JMSSessionProxy p = new JMSSessionProxy(session);
        p.setUseSharedTxContext(this.managedConnection.isInManagedTx());
        this.sessions.add(p);
        return p;
    }

    public void setUseSharedTxContext(boolean enable) throws JMSException {
        Iterator iter = this.sessions.iterator();
        while (iter.hasNext()) {
            JMSSessionProxy p = (JMSSessionProxy)iter.next();
            p.setUseSharedTxContext(enable);
        }
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new ActiveMQQueueSession((QueueSession)this.createSessionProxy(transacted, acknowledgeMode));
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new ActiveMQTopicSession((TopicSession)this.createSessionProxy(transacted, acknowledgeMode));
    }

    public String getClientID() throws JMSException {
        return this.getConnection().getClientID();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.getConnection().getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getConnection().getMetaData();
    }

    public void setClientID(String clientID) throws JMSException {
        this.getConnection().setClientID(clientID);
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.getConnection();
        this.exceptionListener = listener;
    }

    public void start() throws JMSException {
        this.getConnection().start();
    }

    public void stop() throws JMSException {
        this.getConnection().stop();
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("Not Supported.");
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("Not Supported.");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("Not Supported.");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("Not Supported.");
    }

    public ActiveMQManagedConnection getManagedConnection() {
        return this.managedConnection;
    }

    public void onException(JMSException e) {
        if (this.exceptionListener != null && this.managedConnection != null) {
            try {
                this.exceptionListener.onException(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

