/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionAction;
import org.hibernate.cache.CacheException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;

public final class CollectionUpdateAction
extends CollectionAction {
    private final PersistentCollection collection;
    private final boolean emptySnapshot;

    public CollectionUpdateAction(PersistentCollection collection, CollectionPersister persister, Serializable id, boolean emptySnapshot, SessionImplementor session) throws CacheException {
        super(persister, id, session);
        this.collection = collection;
        this.emptySnapshot = emptySnapshot;
    }

    public void execute() throws HibernateException {
        Serializable id = this.getKey();
        SessionImplementor session = this.getSession();
        CollectionPersister persister = this.getPersister();
        if (!this.collection.wasInitialized()) {
            if (!this.collection.hasQueuedAdditions()) {
                throw new AssertionFailure("no queued adds");
            }
        } else if (this.collection.empty()) {
            if (!this.emptySnapshot) {
                persister.remove(id, session);
            }
        } else if (this.collection.needsRecreate(this.getPersister())) {
            if (!this.emptySnapshot) {
                persister.remove(id, session);
            }
            persister.recreate(this.collection, id, session);
        } else {
            persister.deleteRows(this.collection, id, session);
            persister.updateRows(this.collection, id, session);
            persister.insertRows(this.collection, id, session);
        }
        this.evict();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().updateCollection(this.getPersister().getRole());
        }
    }
}

