/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.Hashtable;
import javax.management.ObjectName;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.JCAConnectionFactory;

public class JCAConnectionFactoryImpl
implements JCAConnectionFactory {
    private final String objectName;
    private final String managedConnectionFactory;

    public JCAConnectionFactoryImpl(String objectName, J2EEServer server, String managedConnectionFactory) {
        ObjectName myObjectName = JMXUtil.getObjectName(objectName);
        this.verifyObjectName(myObjectName);
        this.objectName = objectName;
        this.managedConnectionFactory = managedConnectionFactory;
    }

    public String getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return false;
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"JCAConnectionFactory".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("JCAConnectionFactory object name j2eeType property must be 'JCAConnectionFactory'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("JCAConnectionFactory object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("JCAConnectionFactory object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("JCAResource")) {
            throw new InvalidObjectNameException("JCAResource object name must contain a JCAResource property", objectName);
        }
    }
}

