/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.kernel.management.NotificationType;

public final class GBeanInfo
implements Serializable {
    private static final Set DEFAULT_NOTIFICATIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(NotificationType.TYPES)));
    private final String name;
    private final String className;
    private final String j2eeType;
    private final Set attributes;
    private final Map attributesByName;
    private final GConstructorInfo constructor;
    private final Set operations;
    private final Set notifications;
    private final Set references;
    private final Set interfaces;

    public static GBeanInfo getGBeanInfo(String className, ClassLoader classLoader) throws InvalidConfigurationException {
        Method method;
        Class<?> clazz;
        try {
            clazz = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load class " + className, e);
        }
        try {
            method = clazz.getDeclaredMethod("getGBeanInfo", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidConfigurationException("Class does not have a getGBeanInfo() method: " + className);
        }
        try {
            return (GBeanInfo)method.invoke(clazz, new Object[0]);
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Could not get GBeanInfo from class: " + className, e);
        }
    }

    public GBeanInfo(String className, String j2eeType, Collection attributes, GConstructorInfo constructor, Collection operations, Set references, Set interfaces) {
        this(className, className, j2eeType, attributes, constructor, operations, references, interfaces, DEFAULT_NOTIFICATIONS);
    }

    public GBeanInfo(String name, String className, String j2eeType, Collection attributes, GConstructorInfo constructor, Collection operations, Set references, Set interfaces) {
        this(name, className, j2eeType, attributes, constructor, operations, references, interfaces, DEFAULT_NOTIFICATIONS);
    }

    public GBeanInfo(String className, String j2eeType, Collection attributes, GConstructorInfo constructor, Collection operations, Set references, Set interfaces, Set notifications) {
        this(className, className, j2eeType, attributes, constructor, operations, references, interfaces, notifications);
    }

    public GBeanInfo(String name, String className, String j2eeType, Collection attributes, GConstructorInfo constructor, Collection operations, Set references, Set interfaces, Set notifications) {
        this.name = name;
        this.className = className;
        this.j2eeType = j2eeType;
        if (attributes == null) {
            this.attributes = Collections.EMPTY_SET;
            this.attributesByName = Collections.EMPTY_MAP;
        } else {
            HashMap<String, GAttributeInfo> map = new HashMap<String, GAttributeInfo>();
            Iterator iterator = attributes.iterator();
            while (iterator.hasNext()) {
                GAttributeInfo attribute = (GAttributeInfo)iterator.next();
                map.put(attribute.getName(), attribute);
            }
            this.attributesByName = Collections.unmodifiableMap(map);
            this.attributes = Collections.unmodifiableSet(new HashSet(map.values()));
        }
        this.constructor = constructor == null ? new GConstructorInfo(Collections.EMPTY_LIST) : constructor;
        this.operations = operations == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(operations));
        this.references = references == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(references));
        this.interfaces = interfaces == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(interfaces));
        this.notifications = notifications == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(notifications));
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getJ2eeType() {
        return this.j2eeType;
    }

    public GAttributeInfo getAttribute(String name) {
        return (GAttributeInfo)this.attributesByName.get(name);
    }

    public Set getAttributes() {
        return this.attributes;
    }

    public List getPersistentAttributes() {
        ArrayList<GAttributeInfo> attrs = new ArrayList<GAttributeInfo>();
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            GAttributeInfo info = (GAttributeInfo)i.next();
            if (!info.isPersistent()) continue;
            attrs.add(info);
        }
        return attrs;
    }

    public List getManageableAttributes() {
        ArrayList<GAttributeInfo> attrs = new ArrayList<GAttributeInfo>();
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            GAttributeInfo info = (GAttributeInfo)i.next();
            if (!info.isManageable()) continue;
            attrs.add(info);
        }
        return attrs;
    }

    public GConstructorInfo getConstructor() {
        return this.constructor;
    }

    public Set getOperations() {
        return this.operations;
    }

    public Set getNotifications() {
        return this.notifications;
    }

    public Set getReferences() {
        return this.references;
    }

    public Set getInterfaces() {
        return this.interfaces;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[GBeanInfo: id=").append(super.toString()).append(" name=").append(this.name);
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            GAttributeInfo geronimoAttributeInfo = (GAttributeInfo)iterator.next();
            result.append("\n    attribute: ").append(geronimoAttributeInfo);
        }
        iterator = this.operations.iterator();
        while (iterator.hasNext()) {
            GOperationInfo geronimoOperationInfo = (GOperationInfo)iterator.next();
            result.append("\n    operation: ").append(geronimoOperationInfo);
        }
        iterator = this.references.iterator();
        while (iterator.hasNext()) {
            GReferenceInfo referenceInfo = (GReferenceInfo)iterator.next();
            result.append("\n    reference: ").append(referenceInfo);
        }
        result.append("]");
        return result.toString();
    }
}

