/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.gbean.runtime.GBeanSingleReference;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.kernel.management.State;

public class GBeanDependency {
    private final GBeanInstance gbeanInstance;
    private Set patterns = Collections.EMPTY_SET;
    private final LifecycleListener listener;
    private final Set targets = new HashSet();
    private final Kernel kernel;
    private final DependencyManager dependencyManager;
    private boolean isOnline = false;
    private static final Log log = LogFactory.getLog((Class)GBeanSingleReference.class);
    private boolean waitingForMe = false;
    private ObjectName proxyTarget;

    public GBeanDependency(GBeanInstance gbeanInstance, ObjectName pattern, Kernel kernel, DependencyManager dependencyManager) throws InvalidConfigurationException {
        this.gbeanInstance = gbeanInstance;
        this.kernel = kernel;
        this.dependencyManager = dependencyManager;
        this.patterns = Collections.singleton(pattern);
        this.listener = this.createLifecycleListener();
    }

    public synchronized boolean start() {
        if (this.proxyTarget == null) {
            ObjectName target;
            ObjectName objectName = this.getGBeanInstance().getObjectNameObject();
            Set targets = this.getTargets();
            if (targets.size() == 0) {
                this.waitingForMe = true;
                log.debug((Object)("Waiting to start " + objectName + " because no targets are running for the dependency matching the patternspatterns " + this.getPatternsText()));
                return false;
            }
            if (targets.size() > 1) {
                this.waitingForMe = true;
                log.debug((Object)("Waiting to start " + objectName + " because more then one targets are running for the dependency matching the patternspatterns " + this.getPatternsText()));
                return false;
            }
            this.waitingForMe = false;
            DependencyManager dependencyManager = this.getDependencyManager();
            dependencyManager.addStartHolds(objectName, this.getPatterns());
            this.proxyTarget = target = (ObjectName)targets.iterator().next();
            dependencyManager.addDependency(objectName, target);
        }
        return true;
    }

    private String getPatternsText() {
        StringBuffer buf = new StringBuffer();
        Set patterns = this.getPatterns();
        Iterator iterator = patterns.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            buf.append(objectName.getCanonicalName()).append(" ");
        }
        return buf.toString();
    }

    public synchronized void stop() {
        this.waitingForMe = false;
        ObjectName objectName = this.getGBeanInstance().getObjectNameObject();
        Set patterns = this.getPatterns();
        DependencyManager dependencyManager = this.getDependencyManager();
        if (!patterns.isEmpty()) {
            dependencyManager.removeStartHolds(objectName, patterns);
        }
        if (this.proxyTarget != null) {
            dependencyManager.removeDependency(objectName, this.proxyTarget);
            this.proxyTarget = null;
        }
    }

    protected synchronized void targetAdded(ObjectName target) {
        Set targets;
        GBeanInstance gbeanInstance = this.getGBeanInstance();
        if (gbeanInstance.getStateInstance() == State.RUNNING) {
            log.error((Object)("Illegal state: two or more targets are not running for a signle valued reference: " + this.getDescription() + ", currentTarget=" + this.proxyTarget + ", newTarget=" + target));
            gbeanInstance.referenceFailed();
        } else if (this.waitingForMe && (targets = this.getTargets()).size() == 1) {
            this.attemptFullStart();
        }
    }

    protected synchronized void targetRemoved(ObjectName target) {
        Set targets;
        GBeanInstance gbeanInstance = this.getGBeanInstance();
        if (gbeanInstance.getStateInstance() == State.RUNNING) {
            log.error((Object)("Illegal state: current target for a signle valued reference stopped: " + this.getDescription() + ", currentTarget=" + target));
            gbeanInstance.referenceFailed();
        } else if (this.waitingForMe && (targets = this.getTargets()).size() == 1) {
            this.attemptFullStart();
        }
    }

    private synchronized void attemptFullStart() {
        try {
            this.waitingForMe = false;
            this.getGBeanInstance().start();
        }
        catch (Exception e) {
            log.warn((Object)("Exception occured while attempting to fully start: objectName=" + this.getGBeanInstance().getObjectName()), (Throwable)e);
        }
    }

    protected LifecycleListener createLifecycleListener() {
        return new LifecycleAdapter(){

            public void running(ObjectName objectName) {
                GBeanDependency.this.addTarget(objectName);
            }

            public void stopped(ObjectName objectName) {
                GBeanDependency.this.removeTarget(objectName);
            }

            public void failed(ObjectName objectName) {
                GBeanDependency.this.removeTarget(objectName);
            }

            public void unloaded(ObjectName objectName) {
                GBeanDependency.this.removeTarget(objectName);
            }
        };
    }

    protected final Kernel getKernel() {
        return this.kernel;
    }

    protected final DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public final GBeanInstance getGBeanInstance() {
        return this.gbeanInstance;
    }

    public final Set getPatterns() {
        return this.patterns;
    }

    public final void setPatterns(Set patterns) {
        if (this.isOnline) {
            throw new IllegalStateException("Pattern set can not be modified while online");
        }
        if (patterns == null || patterns.isEmpty() || patterns.size() == 1 && patterns.iterator().next() == null) {
            this.patterns = Collections.EMPTY_SET;
        } else {
            patterns = new HashSet(patterns);
            Iterator iterator = this.patterns.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
                break;
            }
            this.patterns = Collections.unmodifiableSet(patterns);
        }
    }

    public final synchronized void online() {
        Set gbeans = this.kernel.listGBeans(this.patterns);
        Iterator objectNameIterator = gbeans.iterator();
        while (objectNameIterator.hasNext()) {
            ObjectName target = (ObjectName)objectNameIterator.next();
            if (this.targets.contains(target) || !this.isRunning(this.kernel, target)) continue;
            this.targets.add(target);
        }
        this.kernel.getLifecycleMonitor().addLifecycleListener(this.listener, this.patterns);
        this.isOnline = true;
    }

    public final synchronized void offline() {
        this.stop();
        this.kernel.getLifecycleMonitor().removeLifecycleListener(this.listener);
        this.targets.clear();
        this.isOnline = false;
    }

    protected final Set getTargets() {
        return this.targets;
    }

    protected final void addTarget(ObjectName objectName) {
        if (!this.targets.contains(objectName)) {
            this.targets.add(objectName);
            this.targetAdded(objectName);
        }
    }

    protected final void removeTarget(ObjectName objectName) {
        boolean wasTarget = this.targets.remove(objectName);
        if (wasTarget) {
            this.targetRemoved(objectName);
        }
    }

    private boolean isRunning(Kernel kernel, ObjectName objectName) {
        try {
            int state = kernel.getGBeanState(objectName);
            return state == 1;
        }
        catch (GBeanNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected final String getDescription() {
        return "\n    GBeanInstance: " + this.gbeanInstance.getName() + "\n    Pattern Name: " + this.getPatterns();
    }
}

