/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.apache.geronimo.kernel.ClassLoading;

public class ObjectInputStreamExt
extends ObjectInputStream {
    private ClassLoader classloader;

    public ObjectInputStreamExt(InputStream in, ClassLoader loader) throws IOException {
        super(in);
        this.classloader = loader;
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        return ClassLoading.loadClass(classDesc.getName(), this.classloader);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.classloader.loadClass(interfaces[i]);
        }
        try {
            return Proxy.getProxyClass(this.classloader, cinterfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    ClassLoader getClassloader() {
        return this.classloader;
    }
}

