/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.context;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.geronimo.transaction.ExtendedTransactionManager;
import org.apache.geronimo.transaction.context.GeronimoTransactionContext;
import org.apache.geronimo.transaction.context.GeronimoTransactionDelegate;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.TransactionContextManager;
import org.apache.geronimo.transaction.context.UnspecifiedTransactionContext;

public class GeronimoTransactionManager
implements UserTransaction,
TransactionManager {
    TransactionContextManager transactionContextManager;

    public GeronimoTransactionManager(TransactionContextManager transactionContextManager) {
        this.transactionContextManager = transactionContextManager;
    }

    public void begin() throws NotSupportedException, SystemException {
        TransactionContext ctx;
        if (this.transactionContextManager.getContext() == null) {
            this.transactionContextManager.newUnspecifiedTransactionContext();
        }
        if (!((ctx = this.transactionContextManager.getContext()) instanceof UnspecifiedTransactionContext)) {
            throw new NotSupportedException("Previous Transaction has not been committed");
        }
        UnspecifiedTransactionContext oldContext = (UnspecifiedTransactionContext)ctx;
        GeronimoTransactionContext transactionContext = new GeronimoTransactionContext(this, (ExtendedTransactionManager)this.transactionContextManager.getTransactionManager(), oldContext);
        oldContext.suspend();
        try {
            transactionContext.begin(0L);
        }
        catch (SystemException e) {
            oldContext.resume();
            throw e;
        }
        catch (NotSupportedException e) {
            oldContext.resume();
            throw e;
        }
        this.transactionContextManager.setContext(transactionContext);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        TransactionContext ctx = this.transactionContextManager.getContext();
        if (!(ctx instanceof GeronimoTransactionContext)) {
            throw new IllegalStateException("Transaction has not been started");
        }
        GeronimoTransactionContext beanContext = (GeronimoTransactionContext)ctx;
        try {
            if (!beanContext.commit()) {
                throw new RollbackException();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            UnspecifiedTransactionContext oldContext = beanContext.getOldContext();
            this.transactionContextManager.setContext(oldContext);
            if (oldContext == null) throw throwable;
            try {
                oldContext.resume();
                throw throwable;
            }
            catch (InvalidTransactionException e) {
                throw (SystemException)new SystemException("Unable to resume perexisting transaction context").initCause(e);
            }
        }
        {
            Object var3_5 = null;
        }
        UnspecifiedTransactionContext oldContext = beanContext.getOldContext();
        this.transactionContextManager.setContext(oldContext);
        if (oldContext == null) return;
        try {}
        catch (InvalidTransactionException e) {
            throw (SystemException)new SystemException("Unable to resume perexisting transaction context").initCause(e);
        }
        oldContext.resume();
    }

    public int getStatus() throws SystemException {
        return this.transactionContextManager.getStatus();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionContext ctx = this.transactionContextManager.getContext();
        if (!(ctx instanceof GeronimoTransactionContext)) {
            throw new IllegalStateException("Transaction has not been started");
        }
        GeronimoTransactionContext beanContext = (GeronimoTransactionContext)ctx;
        try {
            beanContext.rollback();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.transactionContextManager.setContext(null);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.transactionContextManager.setContext(null);
            return;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.transactionContextManager.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            throw new SystemException("transaction timeout must be positive or 0, not " + seconds);
        }
        this.transactionContextManager.setTransactionTimeout(seconds);
    }

    public Transaction getTransaction() throws SystemException {
        TransactionContext context = this.transactionContextManager.getContext();
        if (context == null || context instanceof UnspecifiedTransactionContext) {
            return null;
        }
        if (context instanceof GeronimoTransactionContext) {
            return ((GeronimoTransactionContext)context).getTransactionDelegate();
        }
        throw new IllegalStateException("unrecognized transaction context");
    }

    public void resume(Transaction tx) throws IllegalStateException, InvalidTransactionException, SystemException {
        if (this.transactionContextManager.getContext() == null) {
            this.transactionContextManager.newUnspecifiedTransactionContext();
        }
        if (!(tx instanceof GeronimoTransactionDelegate)) {
            throw new InvalidTransactionException("invalid transaction specified");
        }
        GeronimoTransactionContext ctx = ((GeronimoTransactionDelegate)tx).getContext();
        this.transactionContextManager.resumeBeanTransactionContext(ctx);
    }

    public Transaction suspend() throws SystemException {
        return ((GeronimoTransactionContext)this.transactionContextManager.suspendBeanTransactionContext()).getTransactionDelegate();
    }
}

