/*
 * Decompiled with CFR 0.152.
 */
package org.jencks;

import java.lang.reflect.Method;
import javax.jms.MessageListener;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;
import org.jencks.AcknowledgeEndpoint;
import org.jencks.LocalTransactionEndpoint;
import org.jencks.XAEndpoint;

public abstract class EndpointFactorySupport
implements MessageEndpointFactory {
    protected TransactionManager transactionManager;
    private String name;

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        MessageListener messageListener = this.createMessageListener();
        xaResource = this.wrapXAResource(xaResource);
        if (this.transactionManager != null) {
            return new XAEndpoint(messageListener, xaResource, this.transactionManager);
        }
        if (xaResource instanceof LocalTransaction) {
            return new LocalTransactionEndpoint(messageListener, (LocalTransaction)((Object)xaResource));
        }
        return new AcknowledgeEndpoint(messageListener);
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[transactionManager=" + this.transactionManager + "]";
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        return this.transactionManager != null;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected abstract MessageListener createMessageListener() throws UnavailableException;

    protected XAResource wrapXAResource(XAResource xaResource) {
        String name = this.getName();
        if (xaResource instanceof NamedXAResource || name == null) {
            return xaResource;
        }
        return new WrapperNamedXAResource(xaResource, name);
    }
}

