/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.tranql.connector.AbstractManagedConnection;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.UserPasswordManagedConnectionFactory;
import org.tranql.connector.jdbc.JDBCDriverMCF;

public class ManagedXAConnection
extends AbstractManagedConnection {
    private final CredentialExtractor credentialExtractor;
    private final AbstractManagedConnection.LocalTransactionImpl localTx;
    private final AbstractManagedConnection.LocalTransactionImpl localClientTx;
    private final XAConnection xaConnection;
    private final XAResource xaResource;

    public ManagedXAConnection(ManagedConnectionFactory mcf, XAConnection xaConnection, CredentialExtractor credentialExtractor, ExceptionSorter exceptionSorter) throws SQLException {
        super(mcf, xaConnection.getConnection(), exceptionSorter);
        this.xaConnection = xaConnection;
        xaConnection.addConnectionEventListener(new ConnectionEventListener(){

            public void connectionClosed(ConnectionEvent event) {
            }

            public void connectionErrorOccurred(ConnectionEvent event) {
                SQLException e = event.getSQLException();
                ManagedXAConnection.this.unfilteredConnectionError(e);
            }
        });
        this.xaResource = new AutocommitRestoringXAResource(xaConnection.getXAResource(), (Connection)this.physicalConnection);
        this.credentialExtractor = credentialExtractor;
        this.localTx = new AbstractManagedConnection.LocalTransactionImpl(true);
        this.localClientTx = new AbstractManagedConnection.LocalTransactionImpl(false);
    }

    public boolean matches(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceAdapterInternalException {
        return this.credentialExtractor.matches(subject, connectionRequestInfo, (UserPasswordManagedConnectionFactory)mcf);
    }

    public LocalTransaction getClientLocalTransaction() {
        return this.localClientTx;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localTx;
    }

    protected void localTransactionStart(boolean isSPI) throws ResourceException {
        Connection c = (Connection)this.physicalConnection;
        try {
            c.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new LocalTransactionException("Unable to disable autoCommit", e);
        }
        super.localTransactionStart(isSPI);
    }

    protected void localTransactionCommit(boolean isSPI) throws ResourceException {
        Connection c = (Connection)this.physicalConnection;
        try {
            if (this.mcf instanceof JDBCDriverMCF && ((JDBCDriverMCF)this.mcf).isCommitBeforeAutocommit() != null && ((JDBCDriverMCF)this.mcf).isCommitBeforeAutocommit().booleanValue()) {
                c.commit();
            }
            c.setAutoCommit(true);
        }
        catch (SQLException e) {
            block5: {
                try {
                    c.rollback();
                }
                catch (SQLException e1) {
                    if (this.log == null) break block5;
                    e.printStackTrace(this.log);
                }
            }
            throw new LocalTransactionException("Unable to commit", e);
        }
        super.localTransactionCommit(isSPI);
    }

    protected void localTransactionRollback(boolean isSPI) throws ResourceException {
        Connection c = (Connection)this.physicalConnection;
        try {
            c.rollback();
        }
        catch (SQLException e) {
            throw new LocalTransactionException("Unable to rollback", e);
        }
        super.localTransactionRollback(isSPI);
        try {
            c.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Unable to enable autoCommit after rollback", e);
        }
    }

    public XAResource getXAResource() throws ResourceException {
        return this.xaResource;
    }

    public void cleanup() throws ResourceException {
        super.cleanup();
        Connection c = (Connection)this.physicalConnection;
        try {
            if (!c.getAutoCommit()) {
                c.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new ResourceException("Could not reset autocommit when returning to pool", e);
        }
    }

    protected void closePhysicalConnection() throws ResourceException {
        try {
            this.xaConnection.close();
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Error attempting to destroy managed connection", e);
        }
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return null;
    }

    private static class AutocommitRestoringXAResource
    implements XAResource {
        private final XAResource xaResource;
        private final Connection c;

        public AutocommitRestoringXAResource(XAResource xaResource, Connection c) {
            this.xaResource = xaResource;
            this.c = c;
        }

        public void commit(Xid xid, boolean b) throws XAException {
            this.xaResource.commit(xid, b);
            try {
                if (!this.c.getAutoCommit()) {
                    this.c.setAutoCommit(true);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public void end(Xid xid, int i) throws XAException {
            this.xaResource.end(xid, i);
        }

        public void forget(Xid xid) throws XAException {
            this.xaResource.forget(xid);
        }

        public int getTransactionTimeout() throws XAException {
            return this.xaResource.getTransactionTimeout();
        }

        public boolean isSameRM(XAResource xaResource) throws XAException {
            return this.xaResource.isSameRM(xaResource);
        }

        public int prepare(Xid xid) throws XAException {
            return this.xaResource.prepare(xid);
        }

        public Xid[] recover(int i) throws XAException {
            return this.xaResource.recover(i);
        }

        public void rollback(Xid xid) throws XAException {
            this.xaResource.rollback(xid);
            try {
                if (!this.c.getAutoCommit()) {
                    this.c.setAutoCommit(true);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public boolean setTransactionTimeout(int i) throws XAException {
            return this.xaResource.setTransactionTimeout(i);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void start(Xid xid, int i) throws XAException {
            try {
                if (this.c.getAutoCommit()) {
                    // empty if block
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.xaResource.start(xid, i);
        }
    }
}

