/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.assembler;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.jmx.export.assembler.AbstractConfigurableMBeanInfoAssembler;
import org.springframework.util.StringUtils;

public class MethodExclusionMBeanInfoAssembler
extends AbstractConfigurableMBeanInfoAssembler {
    private Set ignoredMethods;
    private Map ignoredMethodsMappings;

    public void setIgnoredMethods(String[] ignoredMethodNames) {
        this.ignoredMethods = new HashSet<String>(Arrays.asList(ignoredMethodNames));
    }

    public void setIgnoredMethodMappings(Properties mappings) {
        this.ignoredMethodsMappings = new HashMap();
        Enumeration<Object> en = mappings.keys();
        while (en.hasMoreElements()) {
            String beanKey = (String)en.nextElement();
            String[] methodNames = StringUtils.commaDelimitedListToStringArray((String)mappings.getProperty(beanKey));
            this.ignoredMethodsMappings.put(beanKey, new HashSet<String>(Arrays.asList(methodNames)));
        }
    }

    protected boolean includeReadAttribute(Method method, String beanKey) {
        return this.isNotIgnored(method, beanKey);
    }

    protected boolean includeWriteAttribute(Method method, String beanKey) {
        return this.isNotIgnored(method, beanKey);
    }

    protected boolean includeOperation(Method method, String beanKey) {
        return this.isNotIgnored(method, beanKey);
    }

    protected boolean isNotIgnored(Method method, String beanKey) {
        Set methodNames;
        if (this.ignoredMethodsMappings != null && (methodNames = (Set)this.ignoredMethodsMappings.get(beanKey)) != null) {
            return !methodNames.contains(method.getName());
        }
        return this.ignoredMethods != null && !this.ignoredMethods.contains(method.getName());
    }
}

