/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import java.util.Properties;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.config.MvcBeanDefinitionParserSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UrlHandlerMappingBeanDefinitionParser
extends MvcBeanDefinitionParserSupport
implements BeanDefinitionParser {
    private static final String URLMAPPING = "url-mapping";
    private static final String ALWAYS_USE_FULL_PATH = "always-use-full-path";
    private static final String ALWAYS_USE_FULL_PATH_PROPERTY = "alwaysUseFullPath";
    private static final String URL_DECODE = "url-decode";
    private static final String URL_DECODE_PROPERTY = "urlDecode";
    private static final String LAZY_INIT_HANDLERS = "lazy-init-handlers";
    private static final String LAZY_INIT_HANLDERS_PROPERTY = "lazyInitHandlers";
    private static final String DEFAULT_HANDLER = "default-handler";
    private static final String HANDLER = "handler";
    private static final String PATH = "path";
    private static final String CONTROLLER_REF = "controller-ref";
    private static final String INTERCEPTOR = "interceptor";
    private static final String INTERCEPTOR_REF = "interceptor-ref";
    static /* synthetic */ Class class$org$springframework$web$servlet$handler$SimpleUrlHandlerMapping;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Assert.notNull((Object)element);
        Assert.notNull((Object)parserContext);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        NodeList handlerMappingChildren = element.getChildNodes();
        int handlerCount = 0;
        for (int i = 0; i < handlerMappingChildren.getLength(); ++i) {
            Node handlerMapping = handlerMappingChildren.item(i);
            if (!URLMAPPING.equals(handlerMapping.getLocalName()) || handlerMapping.getNodeType() != 1) continue;
            Element el = (Element)handlerMapping;
            RootBeanDefinition handlerMappingDefinition = this.parseHandlerMappingDefinition(el, registry);
            handlerMappingDefinition.getPropertyValues().addPropertyValue("order", (Object)new Integer(handlerCount++));
            registry.registerBeanDefinition(BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)handlerMappingDefinition, (BeanDefinitionRegistry)registry, (boolean)false), (BeanDefinition)handlerMappingDefinition);
        }
        return null;
    }

    private RootBeanDefinition parseHandlerMappingDefinition(Element element, BeanDefinitionRegistry registry) {
        Properties mappings = new Properties();
        ManagedList interceptors = new ManagedList();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element el;
            Node childElement = childNodes.item(i);
            if (HANDLER.equals(childElement.getLocalName()) && childElement.getNodeType() == 1) {
                el = (Element)childElement;
                String path = el.getAttribute(PATH);
                String ref = el.getAttribute(CONTROLLER_REF);
                mappings.put(path, ref);
                continue;
            }
            if (!INTERCEPTOR.equals(childElement.getLocalName()) || childElement.getNodeType() != 1) continue;
            el = (Element)childElement;
            String ref = el.getAttribute(INTERCEPTOR_REF);
            interceptors.add((Object)new RuntimeBeanReference(ref));
        }
        RootBeanDefinition definition = new RootBeanDefinition();
        definition.setBeanClass(class$org$springframework$web$servlet$handler$SimpleUrlHandlerMapping == null ? (class$org$springframework$web$servlet$handler$SimpleUrlHandlerMapping = UrlHandlerMappingBeanDefinitionParser.class$("org.springframework.web.servlet.handler.SimpleUrlHandlerMapping")) : class$org$springframework$web$servlet$handler$SimpleUrlHandlerMapping);
        definition.getPropertyValues().addPropertyValue("mappings", (Object)mappings);
        definition.getPropertyValues().addPropertyValue("interceptors", (Object)interceptors);
        this.setPropertyIfAvailable(element, ALWAYS_USE_FULL_PATH, ALWAYS_USE_FULL_PATH_PROPERTY, definition);
        this.setPropertyIfAvailable(element, URL_DECODE, URL_DECODE_PROPERTY, definition);
        this.setPropertyIfAvailable(element, LAZY_INIT_HANDLERS, LAZY_INIT_HANLDERS_PROPERTY, definition);
        String defaultHandler = element.getAttribute(DEFAULT_HANDLER);
        if (StringUtils.hasText((String)defaultHandler)) {
            definition.getPropertyValues().addPropertyValue("defaultHandler", (Object)defaultHandler);
        }
        return definition;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

