/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class InputTag
extends AbstractHtmlInputElementTag {
    public static final String MAXLENGTH_ATTRIBUTE = "maxlength";
    public static final String ALT_ATTRIBUTE = "alt";
    public static final String ONSELECT_ATTRIBUTE = "onselect";
    public static final String SIZE_ATTRIBUTE = "size";
    private String maxlength;
    private String alt;
    private String onselect;
    private String size;

    public void setMaxlength(String maxlength) {
        Assert.hasText((String)maxlength, (String)"'maxlength' cannot be null or zero length.");
        this.maxlength = maxlength;
    }

    public void setAlt(String alt) {
        Assert.hasText((String)alt, (String)"'alt' cannot be null or zero length.");
        this.alt = alt;
    }

    public void setOnselect(String onselect) {
        Assert.hasText((String)onselect, (String)"'onselect' cannot be null or zero length.");
        this.onselect = onselect;
    }

    public void setSize(String size) {
        Assert.hasText((String)size, (String)"'size' cannot be null or zero length.");
        this.size = size;
    }

    protected String getType() {
        return "text";
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("input");
        this.writeDefaultAttributes(tagWriter);
        tagWriter.writeAttribute("type", this.getType());
        this.writeValue(tagWriter);
        this.writeOptionalAttribute(tagWriter, SIZE_ATTRIBUTE, this.size);
        this.writeOptionalAttribute(tagWriter, MAXLENGTH_ATTRIBUTE, this.maxlength);
        this.writeOptionalAttribute(tagWriter, ALT_ATTRIBUTE, this.alt);
        this.writeOptionalAttribute(tagWriter, ONSELECT_ATTRIBUTE, this.onselect);
        tagWriter.endTag();
        return 6;
    }

    protected void writeValue(TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", ObjectUtils.nullSafeToString((Object)this.getValue()));
    }
}

