/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.springframework.core.style.StylerUtils;
import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.MapAccessor;

public abstract class AbstractAttributeMap
implements AttributeCollection,
Serializable {
    private Map attributes;
    private transient MapAccessor attributeAccessor;

    public Object get(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public int size() {
        return this.attributes.size();
    }

    public Map getMap() {
        return this.attributeAccessor.getMap();
    }

    public boolean contains(String attributeName) {
        return this.attributes.containsKey(attributeName);
    }

    public boolean contains(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.containsKey(attributeName, requiredType);
    }

    public Object get(String attributeName, Object defaultValue) {
        return this.attributeAccessor.get((Object)attributeName, defaultValue);
    }

    public Object get(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.get((Object)attributeName, requiredType);
    }

    public Object get(String attributeName, Class requiredType, Object defaultValue) throws IllegalStateException {
        return this.attributeAccessor.get(attributeName, requiredType, defaultValue);
    }

    public Object getRequired(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequired(attributeName);
    }

    public Object getRequired(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getRequired(attributeName);
    }

    public String getString(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getString(attributeName);
    }

    public String getString(String attributeName, String defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getString(attributeName, defaultValue);
    }

    public String getRequiredString(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredString(attributeName);
    }

    public Collection getCollection(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getCollection(attributeName);
    }

    public Collection getCollection(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getCollection(attributeName, requiredType);
    }

    public Collection getRequiredCollection(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredCollection(attributeName);
    }

    public Collection getRequiredCollection(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredCollection(attributeName);
    }

    public Number getNumber(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getNumber(attributeName, requiredType);
    }

    public Number getNumber(String attributeName, Class requiredType, Number defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getNumber(attributeName, requiredType, defaultValue);
    }

    public Number getRequiredNumber(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredNumber(attributeName, requiredType);
    }

    public Integer getInteger(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getInteger(attributeName);
    }

    public Integer getInteger(String attributeName, Integer defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getInteger(attributeName, defaultValue);
    }

    public Integer getRequiredInteger(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredInteger(attributeName);
    }

    public Long getLong(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getLong(attributeName);
    }

    public Long getLong(String attributeName, Long defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getLong(attributeName, defaultValue);
    }

    public Long getRequiredLong(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredLong(attributeName);
    }

    public Boolean getBoolean(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getBoolean(attributeName);
    }

    public Boolean getBoolean(String attributeName, Boolean defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getBoolean(attributeName, defaultValue);
    }

    public Boolean getRequiredBoolean(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredBoolean(attributeName);
    }

    protected void initAttributes(Map attributes) {
        this.attributes = attributes;
        this.attributeAccessor = new MapAccessor(this.attributes);
    }

    protected Map getMapInternal() {
        return this.attributes;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.attributeAccessor = new MapAccessor(this.attributes);
    }

    public String toString() {
        return StylerUtils.style((Object)this.attributes);
    }
}

