/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import java.util.Iterator;
import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.Action;
import org.springframework.webflow.ActionExecutor;
import org.springframework.webflow.ActionList;
import org.springframework.webflow.Event;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowExecutionControlContext;
import org.springframework.webflow.NoMatchingTransitionException;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.StateException;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionableState;
import org.springframework.webflow.ViewSelection;

public class ActionState
extends TransitionableState {
    private ActionList actionList = new ActionList();

    public ActionState() {
    }

    public ActionState(Flow flow, String id) throws IllegalArgumentException {
        super(flow, id);
    }

    public void addAction(Action action) {
        this.getActionList().add(action);
    }

    public ActionList getActionList() {
        return this.actionList;
    }

    public Transition getRequiredTransition(RequestContext context) throws NoMatchingTransitionException {
        Transition transition = this.getTransitionSet().getTransition(context);
        if (transition == null) {
            throw new NoMatchingActionResultTransitionException(this, context.getLastEvent());
        }
        return transition;
    }

    protected ViewSelection doEnter(FlowExecutionControlContext context) throws StateException {
        int executionCount = 0;
        String[] eventIds = new String[this.actionList.size()];
        Iterator it = this.actionList.iterator();
        while (it.hasNext()) {
            Action action = (Action)it.next();
            Event event = ActionExecutor.execute(action, context);
            if (event != null) {
                eventIds[executionCount] = event.getId();
                try {
                    return context.signalEvent(event);
                }
                catch (NoMatchingActionResultTransitionException e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Action execution [" + (executionCount + 1) + "] resulted in no matching transition on event '" + event.getId() + "'" + (it.hasNext() ? ": proceeding to the next action in the list" : ": action list exhausted")));
                    }
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Action execution [" + (executionCount + 1) + "] returned a [null] event" + (it.hasNext() ? ": proceeding to the next action in the list" : ": action list exhausted")));
                }
                eventIds[executionCount] = null;
            }
            ++executionCount;
        }
        if (executionCount > 0) {
            throw new NoMatchingTransitionException((TransitionableState)this, context.getLastEvent(), "No transition was matched on the event(s) signaled by the [" + executionCount + "] action(s) that executed in this action state '" + this.getId() + "' of flow '" + this.getFlow().getId() + "'; transitions must be defined to handle action result outcomes -- " + "possible flow configuration error? Note: the eventIds signaled were: '" + StylerUtils.style((Object)eventIds) + "', while the supported set of transitional criteria for this action state is '" + StylerUtils.style((Object)this.getTransitionSet().getTransitionCriterias()) + "'");
        }
        throw new IllegalStateException("No actions were executed, thus I cannot execute any state transition -- programmer configuration error; make sure you add at least one action to this state's action list");
    }

    protected void appendToString(ToStringCreator creator) {
        creator.append("actionList", (Object)this.actionList);
        super.appendToString(creator);
    }

    private static class NoMatchingActionResultTransitionException
    extends NoMatchingTransitionException {
        public NoMatchingActionResultTransitionException(ActionState state, Event resultEvent) {
            super(state, resultEvent);
        }
    }
}

