/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import java.util.Iterator;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.Action;
import org.springframework.webflow.ActionList;
import org.springframework.webflow.AnnotatedObject;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Event;
import org.springframework.webflow.FlowExecutionControlContext;
import org.springframework.webflow.NoMatchingTransitionException;
import org.springframework.webflow.NoSuchStateException;
import org.springframework.webflow.State;
import org.springframework.webflow.StateException;
import org.springframework.webflow.StateExceptionHandler;
import org.springframework.webflow.StateExceptionHandlerSet;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionSet;
import org.springframework.webflow.TransitionableState;
import org.springframework.webflow.ViewSelection;

public class Flow
extends AnnotatedObject {
    private String id;
    private Set states = CollectionFactory.createLinkedSetIfPossible((int)6);
    private State startState;
    private ActionList startActionList = new ActionList();
    private TransitionSet globalTransitionSet = new TransitionSet();
    private ActionList endActionList = new ActionList();
    private StateExceptionHandlerSet exceptionHandlerSet = new StateExceptionHandlerSet();
    private Set inlineFlows = CollectionFactory.createLinkedSetIfPossible((int)3);

    public Flow() {
    }

    public Flow(String id) {
        this.setId(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        Assert.hasText((String)id, (String)"This flow must have a unique, non-blank identifier");
        this.id = id;
    }

    protected void add(State state) throws IllegalArgumentException {
        if (this != state.getFlow() && state.getFlow() != null) {
            throw new IllegalArgumentException("State " + state + " cannot be added to this flow '" + this.getId() + "' -- it already belongs to a different flow");
        }
        if (this.states.contains(state)) {
            return;
        }
        if (this.containsState(state.getId())) {
            throw new IllegalArgumentException("This flow '" + this.getId() + "' already contains a state with id '" + state.getId() + "' -- state ids must be locally unique to the flow definition; " + "existing state-ids of this flow include: " + StylerUtils.style((Object)this.getStateIds()));
        }
        boolean firstAdd = this.states.isEmpty();
        this.states.add(state);
        if (firstAdd) {
            this.setStartState(state);
        }
    }

    public int getStateCount() {
        return this.states.size();
    }

    public State[] getStates() {
        return this.states.toArray(new State[this.states.size()]);
    }

    public State getStartState() throws IllegalStateException {
        if (this.startState == null) {
            throw new IllegalStateException("No start state has been set for this flow ('" + this.getId() + "') -- flow builder configuration error?");
        }
        return this.startState;
    }

    public void setStartState(String stateId) throws NoSuchStateException {
        this.setStartState(this.getRequiredState(stateId));
    }

    public void setStartState(State state) throws NoSuchStateException {
        if (!this.states.contains(state)) {
            throw new NoSuchStateException(this, state.getId());
        }
        this.startState = state;
    }

    public boolean containsState(String stateId) {
        return this.getState(stateId) != null;
    }

    public State getState(String stateId) {
        if (!StringUtils.hasText((String)stateId)) {
            throw new IllegalArgumentException("The specified stateId is invalid: state identifiers must be non-blank");
        }
        Iterator it = this.states.iterator();
        while (it.hasNext()) {
            State state = (State)it.next();
            if (!state.getId().equals(stateId)) continue;
            return state;
        }
        return null;
    }

    public State getRequiredState(String stateId) throws NoSuchStateException {
        State state = this.getState(stateId);
        if (state == null) {
            throw new NoSuchStateException(this, stateId);
        }
        return state;
    }

    public TransitionableState getTransitionableState(String stateId) throws IllegalStateException {
        State state = this.getState(stateId);
        if (state != null && !(state instanceof TransitionableState)) {
            throw new IllegalStateException("The state '" + stateId + "' of flow '" + this.getId() + "' must be transitionable");
        }
        return (TransitionableState)state;
    }

    public TransitionableState getRequiredTransitionableState(String stateId) throws IllegalStateException, NoSuchStateException {
        TransitionableState state = this.getTransitionableState(stateId);
        if (state == null) {
            throw new NoSuchStateException(this, stateId);
        }
        return state;
    }

    public String[] getStateIds() {
        String[] stateIds = new String[this.getStateCount()];
        int i = 0;
        Iterator it = this.states.iterator();
        while (it.hasNext()) {
            stateIds[i++] = ((State)it.next()).getId();
        }
        return stateIds;
    }

    public void addStartAction(Action action) {
        this.getStartActionList().add(action);
    }

    public ActionList getStartActionList() {
        return this.startActionList;
    }

    public void addEndAction(Action action) {
        this.getEndActionList().add(action);
    }

    public ActionList getEndActionList() {
        return this.endActionList;
    }

    public void addExceptionHandler(StateExceptionHandler handler) {
        this.exceptionHandlerSet.add(handler);
    }

    public StateExceptionHandlerSet getExceptionHandlerSet() {
        return this.exceptionHandlerSet;
    }

    public void addInlineFlow(Flow flow) {
        this.inlineFlows.add(flow);
    }

    public String[] getInlineFlowIds() {
        String[] flowIds = new String[this.getInlineFlowCount()];
        int i = 0;
        Iterator it = this.inlineFlows.iterator();
        while (it.hasNext()) {
            flowIds[i++] = ((Flow)it.next()).getId();
        }
        return flowIds;
    }

    public Flow[] getInlineFlows() {
        return this.inlineFlows.toArray(new Flow[this.inlineFlows.size()]);
    }

    public int getInlineFlowCount() {
        return this.inlineFlows.size();
    }

    public boolean containsInlineFlow(String id) {
        return this.getInlineFlow(id) != null;
    }

    public Flow getInlineFlow(String id) {
        if (!StringUtils.hasText((String)id)) {
            throw new IllegalArgumentException("The specified inline flowId is invalid: flow identifiers must be non-blank");
        }
        Iterator it = this.inlineFlows.iterator();
        while (it.hasNext()) {
            Flow flow = (Flow)it.next();
            if (!flow.getId().equals(id)) continue;
            return flow;
        }
        return null;
    }

    public void addGlobalTransition(Transition transition) {
        this.getGlobalTransitionSet().add(transition);
    }

    public TransitionSet getGlobalTransitionSet() {
        return this.globalTransitionSet;
    }

    public ViewSelection start(State startState, FlowExecutionControlContext context) {
        if (startState == null) {
            startState = this.getStartState();
        }
        this.startActionList.execute(context);
        return startState.enter(context);
    }

    public ViewSelection onEvent(Event event, FlowExecutionControlContext context) throws NoMatchingTransitionException {
        TransitionableState currentState = this.getCurrentTransitionableState(context);
        try {
            return currentState.onEvent(event, context);
        }
        catch (NoMatchingTransitionException e) {
            Transition transition = this.globalTransitionSet.getTransition(context);
            if (transition != null) {
                return transition.execute(currentState, context);
            }
            throw e;
        }
    }

    private TransitionableState getCurrentTransitionableState(FlowExecutionControlContext context) {
        State currentState = context.getCurrentState();
        if (!(currentState instanceof TransitionableState)) {
            throw new IllegalStateException("You can only signal events in transitionable states, and state " + context.getCurrentState() + "  is not - programmer error");
        }
        return (TransitionableState)currentState;
    }

    public void end(FlowExecutionControlContext context, AttributeMap sessionOutput) {
        this.endActionList.execute(context);
    }

    public ViewSelection handleException(StateException exception, FlowExecutionControlContext context) throws StateException {
        return this.getExceptionHandlerSet().handleException(exception, context);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.id).append("states", (Object)this.states).append("startState", (Object)this.startState).append("startActionList", (Object)this.startActionList).append("exceptionHandlerSet", (Object)this.exceptionHandlerSet).append("endActionList", (Object)this.endActionList).append("transitionSet", (Object)this.globalTransitionSet).append("inlineFlows", (Object)this.inlineFlows).toString();
    }
}

