/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.Action;
import org.springframework.webflow.ActionList;
import org.springframework.webflow.AnnotatedObject;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowExecutionControlContext;
import org.springframework.webflow.StateException;
import org.springframework.webflow.StateExceptionHandler;
import org.springframework.webflow.StateExceptionHandlerSet;
import org.springframework.webflow.ViewSelection;

public abstract class State
extends AnnotatedObject {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Flow flow;
    private String id;
    private ActionList entryActionList = new ActionList();
    private StateExceptionHandlerSet exceptionHandlerSet = new StateExceptionHandlerSet();

    protected State() {
    }

    protected State(Flow flow, String id) throws IllegalArgumentException {
        this.setId(id);
        this.setFlow(flow);
    }

    public Flow getFlow() {
        return this.flow;
    }

    public void setFlow(Flow flow) throws IllegalArgumentException {
        Assert.hasText((String)this.getId(), (String)"The id of the state should be set before adding the state to a flow");
        Assert.notNull((Object)flow, (String)"The owning flow is required");
        flow.add(this);
        this.flow = flow;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        Assert.hasText((String)id, (String)"This state must have a valid identifier");
        Assert.isTrue((this.getFlow() == null ? 1 : 0) != 0, (String)"You cannot change the id of a state which has already been added to a flow");
        this.id = id;
    }

    public void addEntryAction(Action action) {
        this.getEntryActionList().add(action);
    }

    public ActionList getEntryActionList() {
        return this.entryActionList;
    }

    public void addExceptionHandler(StateExceptionHandler handler) {
        this.exceptionHandlerSet.add(handler);
    }

    public StateExceptionHandlerSet getExceptionHandlerSet() {
        return this.exceptionHandlerSet;
    }

    public ViewSelection enter(FlowExecutionControlContext context) throws StateException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entering state '" + this.getId() + "' of flow '" + this.getFlow().getId() + "'"));
        }
        context.setCurrentState(this);
        this.entryActionList.execute(context);
        return this.doEnter(context);
    }

    protected abstract ViewSelection doEnter(FlowExecutionControlContext var1) throws StateException;

    public ViewSelection handleException(StateException exception, FlowExecutionControlContext context) throws StateException {
        return this.getExceptionHandlerSet().handleException(exception, context);
    }

    public String toString() {
        String flowName = this.flow == null ? "<not set>" : this.flow.getId();
        ToStringCreator creator = new ToStringCreator((Object)this).append("id", (Object)this.getId()).append("flow", (Object)flowName).append("entryActionList", (Object)this.entryActionList).append("exceptionHandlerSet", (Object)this.exceptionHandlerSet);
        this.appendToString(creator);
        return creator.toString();
    }

    protected void appendToString(ToStringCreator creator) {
    }
}

